/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.JavaElementKind;
import com.intellij.psi.util.PsiFormatUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HighlightMessageUtil {
    private HighlightMessageUtil() {
    }

    @Nullable
    public static String getSymbolName(@NotNull PsiElement symbol) {
        if (symbol == null) {
            HighlightMessageUtil.$$$reportNull$$$0(0);
        }
        return HighlightMessageUtil.getSymbolName(symbol, PsiSubstitutor.EMPTY);
    }

    @Nullable
    public static String getSymbolName(@NotNull PsiElement symbol, @NotNull PsiSubstitutor substitutor) {
        if (symbol == null) {
            HighlightMessageUtil.$$$reportNull$$$0(1);
        }
        if (substitutor == null) {
            HighlightMessageUtil.$$$reportNull$$$0(2);
        }
        int options = 270338;
        return HighlightMessageUtil.getSymbolName(symbol, substitutor, options);
    }

    @Nullable
    public static String getSymbolName(@NotNull PsiElement symbol, @NotNull PsiSubstitutor substitutor, int parameterOptions) {
        if (symbol == null) {
            HighlightMessageUtil.$$$reportNull$$$0(3);
        }
        if (substitutor == null) {
            HighlightMessageUtil.$$$reportNull$$$0(4);
        }
        String symbolName = null;
        if (symbol instanceof PsiClass) {
            if (symbol instanceof PsiAnonymousClass) {
                symbolName = JavaElementKind.ANONYMOUS_CLASS.subject();
            } else {
                symbolName = ((PsiClass)symbol).getQualifiedName();
                if (symbolName == null) {
                    symbolName = ((PsiClass)symbol).getName();
                }
            }
        } else if (symbol instanceof PsiMethod) {
            int options = 257;
            symbolName = PsiFormatUtil.formatMethod((PsiMethod)symbol, substitutor, options, parameterOptions);
        } else if (symbol instanceof PsiVariable) {
            symbolName = ((PsiVariable)symbol).getName();
        } else if (symbol instanceof PsiPackage) {
            symbolName = ((PsiPackage)symbol).getQualifiedName();
        } else if (symbol instanceof PsiFile) {
            PsiDirectory directory = ((PsiFile)symbol).getContainingDirectory();
            PsiPackage aPackage = directory == null ? null : JavaDirectoryService.getInstance().getPackage(directory);
            symbolName = aPackage == null ? null : aPackage.getQualifiedName();
        } else if (symbol instanceof PsiDirectory) {
            symbolName = ((PsiDirectory)symbol).getName();
        } else if (symbol instanceof PsiJavaModule) {
            symbolName = ((PsiJavaModule)symbol).getName();
        } else if (symbol instanceof PsiNamedElement) {
            symbolName = ((PsiNamedElement)symbol).getName();
        }
        return symbolName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "symbol";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "substitutor";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightMessageUtil";
        objectArray[2] = "getSymbolName";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

