/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.highlighting.service.components;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.kotlin.jupyter.core.util.UtilKt;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.TokenType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\b\u0007\b\u0000\u0018\u0000 92\u00020\u0001:\u000289B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ3\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010 2\b\u0010\"\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010#J\u000e\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u0018J\u0010\u0010&\u001a\u0004\u0018\u00010\u00152\u0006\u0010%\u001a\u00020\u0018J\u001c\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ \u0010+\u001a\u00020\u001e2\b\u0010,\u001a\u0004\u0018\u00010\u00182\u000e\u0010-\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nJ\u000e\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u0018J\u0010\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u0014H\u0002J*\u00102\u001a\b\u0012\u0004\u0012\u00020\u000b0 *\b\u0012\u0004\u0012\u00020\u0018032\b\u00104\u001a\u0004\u0018\u00010\u00182\u0006\u00105\u001a\u00020\u0003H\u0002J\u0006\u00106\u001a\u00020\u001eJ\b\u00107\u001a\u00020\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RA\u0010\t\u001a2\u0012\u000e\u0012\f0\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r \u000f*\u0017\u0012\u000e\u0012\f0\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r0\u000e\u00a2\u0006\u0002\b\f0\n\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0016\u001aB\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00180\u0018\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00190\u0019 \u000f* \u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00180\u0018\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00190\u0019\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0011\u00a8\u0006:"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/service/components/InjectedFilesDataProcessor;", "Lcom/intellij/openapi/Disposable;", "injectedLanguageManager", "Lcom/intellij/lang/injection/InjectedLanguageManager;", "sharedLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "parentDisposable", "<init>", "(Lcom/intellij/lang/injection/InjectedLanguageManager;Lcom/intellij/openapi/diagnostic/Logger;Lcom/intellij/openapi/Disposable;)V", "finishedFilesIndexes", "", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "kotlin.jvm.PlatformType", "getFinishedFilesIndexes", "()Ljava/util/Set;", "fileToInjectionData", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/service/components/InjectedFilesDataProcessor$InjectedFileData;", "unrecognizedFiles", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "Lcom/intellij/psi/PsiFile;", "", "targetPsiFile", "targetIndexes", "getTargetIndexes", "passCreated", "", "cells", "", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "completeRangeInd", "(Ljava/util/Set;Ljava/util/List;Ljava/lang/Integer;)V", "finishedForFile", "psiFile", "getFileInjectionData", "determineFilesLeftToHighlight", "markupModel", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "skippedFiles", "processUnrecognizedFiles", "topLevelFile", "highlightingQueue", "isFileTarget", "file", "numberOfNonWhiteSpaceLeaves", "ktFile", "toCellsIndexes", "", "jupyterPsiFile", "manager", "clear", "dispose", "InjectedFileData", "Companion", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nInjectedFilesDataProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InjectedFilesDataProcessor.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/service/components/InjectedFilesDataProcessor\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n153#2,3:197\n2746#3,3:200\n295#3,2:203\n1788#3,4:205\n1617#3,9:209\n1869#3:218\n1870#3:220\n1626#3:221\n1#4:219\n*S KotlinDebug\n*F\n+ 1 InjectedFilesDataProcessor.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/service/components/InjectedFilesDataProcessor\n*L\n59#1:197,3\n77#1:200,3\n81#1:203,2\n167#1:205,4\n175#1:209,9\n175#1:218\n175#1:220\n175#1:221\n175#1:219\n*E\n"})
public final class InjectedFilesDataProcessor
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InjectedLanguageManager injectedLanguageManager;
    @NotNull
    private final Logger sharedLogger;
    @NotNull
    private final Set<Integer> finishedFilesIndexes;
    @NotNull
    private final ConcurrentHashMap<KtFile, InjectedFileData> fileToInjectionData;
    private final ConcurrentHashMap.KeySetView<PsiFile, Boolean> unrecognizedFiles;
    @Nullable
    private volatile PsiFile targetPsiFile;
    public static final int INJECTED_SYNTAX_LAYER_BORDER = 1999;

    public InjectedFilesDataProcessor(@NotNull InjectedLanguageManager injectedLanguageManager, @NotNull Logger sharedLogger, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)injectedLanguageManager, (String)"injectedLanguageManager");
        Intrinsics.checkNotNullParameter((Object)sharedLogger, (String)"sharedLogger");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.injectedLanguageManager = injectedLanguageManager;
        this.sharedLogger = sharedLogger;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.finishedFilesIndexes = set;
        this.fileToInjectionData = new ConcurrentHashMap();
        this.unrecognizedFiles = ConcurrentHashMap.newKeySet();
    }

    @NotNull
    public final Set<Integer> getFinishedFilesIndexes() {
        return this.finishedFilesIndexes;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Integer> getTargetIndexes() {
        void var2_2;
        void $this$mapTo$iv;
        Map map = this.fileToInjectionData;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv;
            Map.Entry entry = item$iv = iterator.next();
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(((InjectedFileData)it.getValue()).getNotebookCellIndex());
        }
        return (Set)var2_2;
    }

    public final void passCreated(@NotNull Set<Integer> targetIndexes, @Nullable List<? extends PsiLanguageInjectionHost> cells, @Nullable Integer completeRangeInd) {
        Intrinsics.checkNotNullParameter(targetIndexes, (String)"targetIndexes");
        if (cells == null) {
            return;
        }
        Iterator<Integer> iterator = targetIndexes.iterator();
        while (iterator.hasNext()) {
            TextRange ktFileRange;
            Pair pair;
            Object v1;
            PsiLanguageInjectionHost psiCell;
            int ind;
            block9: {
                Object element$iv2;
                boolean bl;
                List injectedPsiFiles;
                block8: {
                    ind = ((Number)iterator.next()).intValue();
                    if ((PsiLanguageInjectionHost)kotlin.collections.CollectionsKt.getOrNull(cells, (int)ind) == null) continue;
                    injectedPsiFiles = this.injectedLanguageManager.getInjectedPsiFiles((PsiElement)psiCell);
                    if (injectedPsiFiles == null) {
                        this.finishedFilesIndexes.add(ind);
                        continue;
                    }
                    Iterable $this$none$iv = injectedPsiFiles;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv2 : $this$none$iv) {
                            Pair f = (Pair)element$iv2;
                            boolean bl2 = false;
                            if (!(f.first instanceof KtFile)) continue;
                            bl = false;
                            break block8;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    this.finishedFilesIndexes.add(ind);
                    continue;
                }
                Iterable $this$firstOrNull$iv = injectedPsiFiles;
                boolean $i$f$firstOrNull = false;
                element$iv2 = $this$firstOrNull$iv.iterator();
                while (element$iv2.hasNext()) {
                    Object element$iv3 = element$iv2.next();
                    Pair f = (Pair)element$iv3;
                    boolean bl3 = false;
                    if (!(f.first instanceof KtFile)) continue;
                    v1 = element$iv3;
                    break block9;
                }
                v1 = null;
            }
            if ((pair = (Pair)v1) == null || (pair = (PsiElement)pair.first) == null) continue;
            Pair ktFile = pair;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)this.injectedLanguageManager.injectedToHost((PsiElement)ktFile, ktFile.getTextRange()), (String)"injectedToHost(...)");
            ((Map)this.fileToInjectionData).put((KtFile)ktFile, new InjectedFileData(ind, (KtFile)ktFile, ktFileRange, psiCell, this.numberOfNonWhiteSpaceLeaves((KtFile)ktFile)));
            Integer n = completeRangeInd;
            if (n == null || ind != n) continue;
            this.targetPsiFile = (PsiFile)ktFile;
        }
        this.unrecognizedFiles.clear();
    }

    public final void finishedForFile(@NotNull PsiFile psiFile) {
        Integer ind;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        InjectedFileData injectedFileData = (InjectedFileData)((Map)this.fileToInjectionData).get(psiFile);
        Integer n = ind = injectedFileData != null ? Integer.valueOf(injectedFileData.getNotebookCellIndex()) : null;
        if (ind == null) {
            this.sharedLogger.info("Seen unrecognized file during pass");
            return;
        }
        CollectionsKt.addIfNotNull((Collection)this.finishedFilesIndexes, (Object)ind);
        this.sharedLogger.debug("Finished visitors for " + ind);
    }

    @Nullable
    public final InjectedFileData getFileInjectionData(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return (InjectedFileData)((Map)this.fileToInjectionData).get(psiFile);
    }

    public final void determineFilesLeftToHighlight(@NotNull MarkupModelEx markupModel, @NotNull Set<Integer> skippedFiles) {
        Intrinsics.checkNotNullParameter((Object)markupModel, (String)"markupModel");
        Intrinsics.checkNotNullParameter(skippedFiles, (String)"skippedFiles");
        ConcurrentHashMap<KtFile, InjectedFileData> data = this.fileToInjectionData;
        Iterator iterator = ((Map)data).entrySet().iterator();
        while (iterator.hasNext()) {
            InjectedFileData fileData = (InjectedFileData)iterator.next().getValue();
            TextRange range = fileData.getKtFileRange();
            if (range.getLength() == 0) continue;
            fileData.getProcessedTokens().set(0);
            Set seenHighlighters = new LinkedHashSet();
            markupModel.processRangeHighlightersOverlappingWith(range.getStartOffset(), range.getEndOffset(), arg_0 -> InjectedFilesDataProcessor.determineFilesLeftToHighlight$lambda$5(arg_0 -> InjectedFilesDataProcessor.determineFilesLeftToHighlight$lambda$4(seenHighlighters, fileData, arg_0), arg_0));
            int tokens = seenHighlighters.size();
            if (tokens >= fileData.getTotalTokens() - 1) continue;
            skippedFiles.add(fileData.getNotebookCellIndex());
        }
    }

    public final void processUnrecognizedFiles(@Nullable PsiFile topLevelFile, @Nullable Set<Integer> highlightingQueue) {
        ConcurrentHashMap.KeySetView<PsiFile, Boolean> unrecognizedFiles = this.unrecognizedFiles;
        Intrinsics.checkNotNull(unrecognizedFiles);
        if (!((Collection)unrecognizedFiles).isEmpty()) {
            List unseenFiles = (List)ReadAction.compute(() -> InjectedFilesDataProcessor.processUnrecognizedFiles$lambda$6(this, unrecognizedFiles, topLevelFile));
            Set<Integer> set = highlightingQueue;
            if (set != null) {
                Intrinsics.checkNotNull((Object)unseenFiles);
                set.addAll(unseenFiles);
            }
            unrecognizedFiles.clear();
        }
    }

    public final boolean isFileTarget(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file, (Object)this.targetPsiFile);
    }

    private final int numberOfNonWhiteSpaceLeaves(KtFile ktFile) {
        int n;
        JBIterable jBIterable = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)ktFile)).traverse(TreeTraversal.LEAVES_DFS);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"traverse(...)");
        Iterable $this$count$iv = (Iterable)jBIterable;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                PsiElement psiLeaf = (PsiElement)element$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)psiLeaf), (Object)TokenType.WHITE_SPACE) && !(psiLeaf instanceof KtPackageDirective)) || ++count$iv >= 0) continue;
                kotlin.collections.CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> toCellsIndexes(Collection<? extends PsiFile> $this$toCellsIndexes, PsiFile jupyterPsiFile, InjectedLanguageManager manager) {
        void $this$mapNotNullTo$iv$iv;
        List<JupyterPsiCell> cells = UtilKt.getNotebookCells(jupyterPsiFile);
        Iterable $this$mapNotNull$iv = $this$toCellsIndexes;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PsiFile injected = (PsiFile)element$iv$iv;
            boolean bl2 = false;
            Integer it$iv$iv = kotlin.collections.CollectionsKt.indexOf(cells, (Object)manager.getInjectionHost((PsiElement)injected));
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void clear() {
        this.unrecognizedFiles.clear();
        this.targetPsiFile = null;
        this.fileToInjectionData.clear();
        this.finishedFilesIndexes.clear();
    }

    public void dispose() {
        this.clear();
    }

    private static final boolean determineFilesLeftToHighlight$lambda$4(Set $seenHighlighters, InjectedFileData $fileData, RangeHighlighterEx it) {
        if (it.getLayer() < 1999 && it.getLayer() != 5000) {
            Intrinsics.checkNotNull((Object)it);
            if ($seenHighlighters.add(it)) {
                $fileData.getProcessedTokens().incrementAndGet();
            }
        }
        return true;
    }

    private static final boolean determineFilesLeftToHighlight$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final List processUnrecognizedFiles$lambda$6(InjectedFilesDataProcessor this$0, ConcurrentHashMap.KeySetView $unrecognizedFiles, PsiFile $topLevelFile) {
        Intrinsics.checkNotNull((Object)$unrecognizedFiles);
        return this$0.toCellsIndexes($unrecognizedFiles, $topLevelFile, this$0.injectedLanguageManager);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/service/components/InjectedFilesDataProcessor$Companion;", "", "<init>", "()V", "INJECTED_SYNTAX_LAYER_BORDER", "", "intellij.kotlin.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006&"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/service/components/InjectedFilesDataProcessor$InjectedFileData;", "", "notebookCellIndex", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "ktFileRange", "Lcom/intellij/openapi/util/TextRange;", "injectionHost", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "totalTokens", "<init>", "(ILorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/util/TextRange;Lcom/intellij/psi/PsiLanguageInjectionHost;I)V", "getNotebookCellIndex", "()I", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getKtFileRange", "()Lcom/intellij/openapi/util/TextRange;", "getInjectionHost", "()Lcom/intellij/psi/PsiLanguageInjectionHost;", "getTotalTokens", "processedTokens", "Ljava/util/concurrent/atomic/AtomicInteger;", "getProcessedTokens", "()Ljava/util/concurrent/atomic/AtomicInteger;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.kotlin.jupyter.core"})
    public static final class InjectedFileData {
        private final int notebookCellIndex;
        @NotNull
        private final KtFile file;
        @NotNull
        private final TextRange ktFileRange;
        @NotNull
        private final PsiLanguageInjectionHost injectionHost;
        private final int totalTokens;
        @NotNull
        private final AtomicInteger processedTokens;

        public InjectedFileData(int notebookCellIndex, @NotNull KtFile file, @NotNull TextRange ktFileRange, @NotNull PsiLanguageInjectionHost injectionHost, int totalTokens) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)ktFileRange, (String)"ktFileRange");
            Intrinsics.checkNotNullParameter((Object)injectionHost, (String)"injectionHost");
            this.notebookCellIndex = notebookCellIndex;
            this.file = file;
            this.ktFileRange = ktFileRange;
            this.injectionHost = injectionHost;
            this.totalTokens = totalTokens;
            this.processedTokens = new AtomicInteger(0);
        }

        public final int getNotebookCellIndex() {
            return this.notebookCellIndex;
        }

        @NotNull
        public final KtFile getFile() {
            return this.file;
        }

        @NotNull
        public final TextRange getKtFileRange() {
            return this.ktFileRange;
        }

        @NotNull
        public final PsiLanguageInjectionHost getInjectionHost() {
            return this.injectionHost;
        }

        public final int getTotalTokens() {
            return this.totalTokens;
        }

        @NotNull
        public final AtomicInteger getProcessedTokens() {
            return this.processedTokens;
        }

        public final int component1() {
            return this.notebookCellIndex;
        }

        @NotNull
        public final KtFile component2() {
            return this.file;
        }

        @NotNull
        public final TextRange component3() {
            return this.ktFileRange;
        }

        @NotNull
        public final PsiLanguageInjectionHost component4() {
            return this.injectionHost;
        }

        public final int component5() {
            return this.totalTokens;
        }

        @NotNull
        public final InjectedFileData copy(int notebookCellIndex, @NotNull KtFile file, @NotNull TextRange ktFileRange, @NotNull PsiLanguageInjectionHost injectionHost, int totalTokens) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)ktFileRange, (String)"ktFileRange");
            Intrinsics.checkNotNullParameter((Object)injectionHost, (String)"injectionHost");
            return new InjectedFileData(notebookCellIndex, file, ktFileRange, injectionHost, totalTokens);
        }

        public static /* synthetic */ InjectedFileData copy$default(InjectedFileData injectedFileData, int n, KtFile ktFile, TextRange textRange, PsiLanguageInjectionHost psiLanguageInjectionHost, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = injectedFileData.notebookCellIndex;
            }
            if ((n3 & 2) != 0) {
                ktFile = injectedFileData.file;
            }
            if ((n3 & 4) != 0) {
                textRange = injectedFileData.ktFileRange;
            }
            if ((n3 & 8) != 0) {
                psiLanguageInjectionHost = injectedFileData.injectionHost;
            }
            if ((n3 & 0x10) != 0) {
                n2 = injectedFileData.totalTokens;
            }
            return injectedFileData.copy(n, ktFile, textRange, psiLanguageInjectionHost, n2);
        }

        @NotNull
        public String toString() {
            return "InjectedFileData(notebookCellIndex=" + this.notebookCellIndex + ", file=" + this.file + ", ktFileRange=" + this.ktFileRange + ", injectionHost=" + this.injectionHost + ", totalTokens=" + this.totalTokens + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.notebookCellIndex);
            result2 = result2 * 31 + this.file.hashCode();
            result2 = result2 * 31 + this.ktFileRange.hashCode();
            result2 = result2 * 31 + this.injectionHost.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.totalTokens);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InjectedFileData)) {
                return false;
            }
            InjectedFileData injectedFileData = (InjectedFileData)other;
            if (this.notebookCellIndex != injectedFileData.notebookCellIndex) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.file, (Object)injectedFileData.file)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.ktFileRange, (Object)injectedFileData.ktFileRange)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.injectionHost, (Object)injectedFileData.injectionHost)) {
                return false;
            }
            return this.totalTokens == injectedFileData.totalTokens;
        }
    }
}

