/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import java.io.File;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;

public abstract class TransformStepSubject
implements Describable {
    public static TransformStepSubject initial(ResolvableArtifact artifact) {
        return new Initial(artifact);
    }

    public abstract ImmutableList<File> getFiles();

    public abstract ComponentIdentifier getInitialComponentIdentifier();

    public TransformStepSubject createSubjectFromResult(ImmutableList<File> result) {
        return new Transformed(this, result);
    }

    private static class Initial
    extends TransformStepSubject {
        private final ResolvableArtifact artifact;

        public Initial(ResolvableArtifact artifact) {
            this.artifact = artifact;
        }

        @Override
        public ImmutableList<File> getFiles() {
            return ImmutableList.of((Object)this.artifact.getFile());
        }

        public String getDisplayName() {
            return this.artifact.getId().getDisplayName();
        }

        @Override
        public ComponentIdentifier getInitialComponentIdentifier() {
            return this.artifact.getId().getComponentIdentifier();
        }
    }

    private static class Transformed
    extends TransformStepSubject {
        private final TransformStepSubject previous;
        private final ImmutableList<File> files;

        public Transformed(TransformStepSubject previous, ImmutableList<File> files) {
            this.previous = previous;
            this.files = files;
        }

        @Override
        public ImmutableList<File> getFiles() {
            return this.files;
        }

        @Override
        public ComponentIdentifier getInitialComponentIdentifier() {
            return this.previous.getInitialComponentIdentifier();
        }

        public String getDisplayName() {
            return this.previous.getDisplayName();
        }

        public String toString() {
            return this.getDisplayName();
        }
    }
}

