/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import com.amazon.aes.webservices.client.volumeStatus.VolumeStatusContainer;
import java.math.BigInteger;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeVolumeStatus
extends BaseCmd {
    private static final String HIDE_HEALTHY = "HIDE-HEALTHY";
    private static final String HIDE_HEALTHY_SHORTOPT = "I";
    private static final String HIDE_HEALTHY_LONGOPT = "hide-healthy";
    private static final String HIDE_HEALTHY_DESCRIPTION = "Hide volumes where all status checks pass.";

    public DescribeVolumeStatus(String[] args) {
        super("ec2dvs", "ec2-describe-volume-status");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)"Add a filter criterion for the result-set.");
        o.addOption(OptionBuilder.create((String)"F"));
        OptionBuilder.withLongOpt((String)HIDE_HEALTHY_LONGOPT);
        OptionBuilder.withArgName((String)HIDE_HEALTHY);
        OptionBuilder.withDescription((String)HIDE_HEALTHY_DESCRIPTION);
        OptionBuilder.isRequired((boolean)false);
        o.addOption(OptionBuilder.create((String)HIDE_HEALTHY_SHORTOPT));
        return o;
    }

    @Override
    public String getOptionString() {
        return "[-h] [VOLUME [VOLUME [...]]]";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Describe the status for one or more volumes.");
        System.out.println("     Checks are performed on your volumes to determine if they are ");
        System.out.println("     in running order or not. Use this command to see the result of these ");
        System.out.println("     volume checks so that you can take remedial action if possible.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption(HIDE_HEALTHY_LONGOPT);
        this.printOption("filter");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String[] volumeIds = this.getNonOptions();
        BigInteger maxResults = volumeIds != null && volumeIds.length > 0 ? null : new BigInteger("1000");
        String nextToken = null;
        do {
            RequestResultPair rsp = jec2.describeVolumeStatus(volumeIds, maxResults, this.getFilters(true), nextToken);
            VolumeStatusContainer container = (VolumeStatusContainer)rsp.getResponse();
            nextToken = container.getNextToken();
            out.outputVolumeStatusDescriptions(System.out, container.getVolumeStatusDescriptions(), this.isOptionSet(HIDE_HEALTHY_SHORTOPT));
            out.printRequestId(System.out, (RequestResult)rsp);
            if (nextToken != "") continue;
            nextToken = null;
        } while (nextToken != null);
        return true;
    }

    public static void main(String[] args) {
        new DescribeVolumeStatus(args).invoke();
    }
}

