/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.std.JdkDeserializers;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.EnumResolver;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;

public abstract class StdKeyDeserializer
extends KeyDeserializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Class<?> _keyClass;

    protected StdKeyDeserializer(Class<?> cls) {
        this._keyClass = cls;
    }

    @Override
    public final Object deserializeKey(String key, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (key == null) {
            return null;
        }
        try {
            Object result = this._parse(key, ctxt);
            if (result != null) {
                return result;
            }
        }
        catch (Exception re) {
            throw ctxt.weirdKeyException(this._keyClass, key, "not a valid representation: " + re.getMessage());
        }
        if (this._keyClass.isEnum() && ctxt.getConfig().isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
            return null;
        }
        throw ctxt.weirdKeyException(this._keyClass, key, "not a valid representation");
    }

    public Class<?> getKeyClass() {
        return this._keyClass;
    }

    protected abstract Object _parse(String var1, DeserializationContext var2) throws Exception;

    protected int _parseInt(String key) throws IllegalArgumentException {
        return Integer.parseInt(key);
    }

    protected long _parseLong(String key) throws IllegalArgumentException {
        return Long.parseLong(key);
    }

    protected double _parseDouble(String key) throws IllegalArgumentException {
        return NumberInput.parseDouble((String)key);
    }

    @JacksonStdImpl
    static final class UuidKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;

        protected UuidKD() {
            super(UUID.class);
        }

        @Override
        public Object _parse(String key, DeserializationContext ctxt) throws IllegalArgumentException, JsonMappingException {
            return UUID.fromString(key);
        }
    }

    @JacksonStdImpl
    static final class CalendarKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;

        protected CalendarKD() {
            super(Calendar.class);
        }

        @Override
        public Object _parse(String key, DeserializationContext ctxt) throws IllegalArgumentException, JsonMappingException {
            Date date = ctxt.parseDate(key);
            return date == null ? null : ctxt.constructCalendar(date);
        }
    }

    @JacksonStdImpl
    static final class DateKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;

        protected DateKD() {
            super(Date.class);
        }

        @Override
        public Object _parse(String key, DeserializationContext ctxt) throws IllegalArgumentException, JsonMappingException {
            return ctxt.parseDate(key);
        }
    }

    static final class StringFactoryKeyDeserializer
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;
        final Method _factoryMethod;

        public StringFactoryKeyDeserializer(Method fm) {
            super(fm.getDeclaringClass());
            this._factoryMethod = fm;
        }

        @Override
        public Object _parse(String key, DeserializationContext ctxt) throws Exception {
            return this._factoryMethod.invoke(null, key);
        }
    }

    static final class StringCtorKeyDeserializer
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;
        protected final Constructor<?> _ctor;

        public StringCtorKeyDeserializer(Constructor<?> ctor) {
            super(ctor.getDeclaringClass());
            this._ctor = ctor;
        }

        @Override
        public Object _parse(String key, DeserializationContext ctxt) throws Exception {
            return this._ctor.newInstance(key);
        }
    }

    @JacksonStdImpl
    static final class EnumKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;
        protected final EnumResolver<?> _resolver;
        protected final AnnotatedMethod _factory;

        protected EnumKD(EnumResolver<?> er, AnnotatedMethod factory) {
            super(er.getEnumClass());
            this._resolver = er;
            this._factory = factory;
        }

        @Override
        public Object _parse(String key, DeserializationContext ctxt) throws JsonMappingException {
            Object e;
            if (this._factory != null) {
                try {
                    return this._factory.call1(key);
                }
                catch (Exception e2) {
                    ClassUtil.unwrapAndThrowAsIAE(e2);
                }
            }
            if ((e = this._resolver.findEnum(key)) == null && !ctxt.getConfig().isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
                throw ctxt.weirdKeyException(this._keyClass, key, "not one of values for Enum class");
            }
            return e;
        }
    }

    static final class DelegatingKD
    extends KeyDeserializer
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final Class<?> _keyClass;
        protected final JsonDeserializer<?> _delegate;

        protected DelegatingKD(Class<?> cls, JsonDeserializer<?> deser) {
            this._keyClass = cls;
            this._delegate = deser;
        }

        @Override
        public final Object deserializeKey(String key, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (key == null) {
                return null;
            }
            try {
                Object result = this._delegate.deserialize(ctxt.getParser(), ctxt);
                if (result != null) {
                    return result;
                }
            }
            catch (Exception re) {
                throw ctxt.weirdKeyException(this._keyClass, key, "not a valid representation: " + re.getMessage());
            }
            throw ctxt.weirdKeyException(this._keyClass, key, "not a valid representation");
        }

        public Class<?> getKeyClass() {
            return this._keyClass;
        }
    }

    @JacksonStdImpl
    static final class LocaleKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;
        protected JdkDeserializers.LocaleDeserializer _localeDeserializer = new JdkDeserializers.LocaleDeserializer();

        LocaleKD() {
            super(Locale.class);
        }

        @Override
        protected Locale _parse(String key, DeserializationContext ctxt) throws JsonMappingException {
            try {
                return this._localeDeserializer._deserialize(key, ctxt);
            }
            catch (IOException e) {
                throw ctxt.weirdKeyException(this._keyClass, key, "unable to parse key as locale");
            }
        }
    }

    @JacksonStdImpl
    static final class FloatKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;

        FloatKD() {
            super(Float.class);
        }

        @Override
        public Float _parse(String key, DeserializationContext ctxt) throws JsonMappingException {
            return Float.valueOf((float)this._parseDouble(key));
        }
    }

    @JacksonStdImpl
    static final class DoubleKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;

        DoubleKD() {
            super(Double.class);
        }

        @Override
        public Double _parse(String key, DeserializationContext ctxt) throws JsonMappingException {
            return this._parseDouble(key);
        }
    }

    @JacksonStdImpl
    static final class LongKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;

        LongKD() {
            super(Long.class);
        }

        @Override
        public Long _parse(String key, DeserializationContext ctxt) throws JsonMappingException {
            return this._parseLong(key);
        }
    }

    @JacksonStdImpl
    static final class IntKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;

        IntKD() {
            super(Integer.class);
        }

        @Override
        public Integer _parse(String key, DeserializationContext ctxt) throws JsonMappingException {
            return this._parseInt(key);
        }
    }

    @JacksonStdImpl
    static final class CharKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;

        CharKD() {
            super(Character.class);
        }

        @Override
        public Character _parse(String key, DeserializationContext ctxt) throws JsonMappingException {
            if (key.length() == 1) {
                return Character.valueOf(key.charAt(0));
            }
            throw ctxt.weirdKeyException(this._keyClass, key, "can only convert 1-character Strings");
        }
    }

    @JacksonStdImpl
    static final class ShortKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;

        ShortKD() {
            super(Integer.class);
        }

        @Override
        public Short _parse(String key, DeserializationContext ctxt) throws JsonMappingException {
            int value = this._parseInt(key);
            if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
                throw ctxt.weirdKeyException(this._keyClass, key, "overflow, value can not be represented as 16-bit value");
            }
            return (short)value;
        }
    }

    @JacksonStdImpl
    static final class ByteKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;

        ByteKD() {
            super(Byte.class);
        }

        @Override
        public Byte _parse(String key, DeserializationContext ctxt) throws JsonMappingException {
            int value = this._parseInt(key);
            if (value < -128 || value > 255) {
                throw ctxt.weirdKeyException(this._keyClass, key, "overflow, value can not be represented as 8-bit value");
            }
            return (byte)value;
        }
    }

    @JacksonStdImpl
    static final class BoolKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;

        BoolKD() {
            super(Boolean.class);
        }

        @Override
        public Boolean _parse(String key, DeserializationContext ctxt) throws JsonMappingException {
            if ("true".equals(key)) {
                return Boolean.TRUE;
            }
            if ("false".equals(key)) {
                return Boolean.FALSE;
            }
            throw ctxt.weirdKeyException(this._keyClass, key, "value not 'true' or 'false'");
        }
    }

    @JacksonStdImpl
    static final class StringKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;
        private static final StringKD sString = new StringKD(String.class);
        private static final StringKD sObject = new StringKD(Object.class);

        private StringKD(Class<?> nominalType) {
            super(nominalType);
        }

        public static StringKD forType(Class<?> nominalType) {
            if (nominalType == String.class) {
                return sString;
            }
            if (nominalType == Object.class) {
                return sObject;
            }
            return new StringKD(nominalType);
        }

        @Override
        public String _parse(String key, DeserializationContext ctxt) throws JsonMappingException {
            return key;
        }
    }
}

