untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQ4OxjFuyRvq5X47YqvxsDviyNWsmDqtG+bOxWYJsV6CDVnisQIPcMl/nQkIUX93yT5e1kKdOkDVIRBfgO++CcQM=

OpenBSD 6.0 errata 19, Mar 9, 2017:

Prevent integer overflow in PF when calculating the adaptive timeout,
causing spuriously expired states under pressure.

Alternatively, disable adaptive timeouts with
  set timeout { adaptive.start 0, adaptive.end 0 }

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 019_pf.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/net/pf.c
===================================================================
RCS file: /cvs/src/sys/net/pf.c,v
retrieving revision 1.979
diff -u -p -r1.979 pf.c
--- sys/net/pf.c	18 Jul 2016 13:17:44 -0000	1.979
+++ sys/net/pf.c	9 Mar 2017 14:58:15 -0000
@@ -1194,7 +1194,7 @@ pf_purge_thread(void *v)
 int32_t
 pf_state_expires(const struct pf_state *state)
 {
-	int32_t		timeout;
+	u_int32_t	timeout;
 	u_int32_t	start;
 	u_int32_t	end;
 	u_int32_t	states;
@@ -1223,7 +1223,7 @@ pf_state_expires(const struct pf_state *
 		if (states >= end)
 			return (0);
 
-		timeout = timeout * (end - states) / (end - start);
+		timeout = (u_int64_t)timeout * (end - states) / (end - start);
 	}
 
 	return (state->expire + timeout);
