untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQ/PhYXHNfj2UaVm8wrh7ryXGjD/GjFYJtJDPPJuUywpddLSSZAjKUY1Hasp10eBD4wjNtePER2jTjvile65NvQg=

OpenBSD 6.0 errata 05, Sep 17, 2016:

Limit the number of wscons fonts that can be loaded into the kernel.

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 005_wsfont.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/dev/wscons/wsconsio.h
===================================================================
RCS file: /cvs/src/sys/dev/wscons/wsconsio.h,v
retrieving revision 1.74
retrieving revision 1.74.2.1
diff -u -p -r1.74 -r1.74.2.1
--- sys/dev/wscons/wsconsio.h	30 Mar 2016 23:34:12 -0000	1.74
+++ sys/dev/wscons/wsconsio.h	16 Sep 2016 14:54:37 -0000	1.74.2.1
@@ -418,6 +418,7 @@ struct wsdisplay_cursor {
 struct wsdisplay_font {
 	char name[WSFONT_NAME_SIZE];
 	int index;
+#define WSDISPLAY_MAXFONTCOUNT	8
 	int firstchar, numchars;
 	int encoding;
 #define WSDISPLAY_FONTENC_ISO 0
Index: sys/dev/wsfont/wsfont.c
===================================================================
RCS file: /cvs/src/sys/dev/wsfont/wsfont.c,v
retrieving revision 1.42
retrieving revision 1.42.4.1
diff -u -p -r1.42 -r1.42.4.1
--- sys/dev/wsfont/wsfont.c	13 Sep 2015 16:44:30 -0000	1.42
+++ sys/dev/wsfont/wsfont.c	16 Sep 2016 14:54:37 -0000	1.42.4.1
@@ -450,13 +450,21 @@ wsfont_add(struct wsdisplay_font *font, 
 {
 	static int cookiegen = 666;
 	struct font *ent;
-	int s;
+	int s, fontc = 0;
 
 	s = splhigh();
 
 	/* Don't allow exact duplicates */
 	if (wsfont_find(font->name, font->fontwidth, font->fontheight,
 	    font->stride) >= 0) {
+		splx(s);
+		return (-1);
+	}
+
+	TAILQ_FOREACH(ent, &fontlist, chain)
+		fontc++;
+
+	if (fontc >= WSDISPLAY_MAXFONTCOUNT) {
 		splx(s);
 		return (-1);
 	}
