/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.print;

import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.print.PageableScene;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScenePrinter {
    private ScenePrinter() {
    }

    public static void print(Scene scene) {
        ScenePrinter.print(scene, null, ScaleStrategy.NO_SCALING);
    }

    public static void print(Scene scene, PageFormat pageFormat) {
        ScenePrinter.print(scene, pageFormat, ScaleStrategy.NO_SCALING);
    }

    public static void print(Scene scene, ScaleStrategy scaleStrategy) {
        ScenePrinter.print(scene, null, scaleStrategy);
    }

    public static void print(Scene scene, double d, double d2) {
        ScenePrinter.print(scene, null, ScaleStrategy.SCALE_PERCENT, d, d2, false, false, null, null);
    }

    public static void print(Scene scene, PageFormat pageFormat, ScaleStrategy scaleStrategy) {
        ScenePrinter.print(scene, pageFormat, scaleStrategy, 1.0, 1.0, false, false, null, null);
    }

    public static void print(Scene scene, PageFormat pageFormat, Rectangle rectangle) {
        ScenePrinter.print(scene, pageFormat, ScaleStrategy.NO_SCALING, 1.0, 1.0, false, false, rectangle, null);
    }

    public static void print(Scene scene, PageFormat pageFormat, ScaleStrategy scaleStrategy, double d, double d2, boolean bl, boolean bl2, Rectangle rectangle, List<LayerWidget> list) {
        if (scene == null) {
            return;
        }
        if (scaleStrategy == null) {
            scaleStrategy = ScaleStrategy.NO_SCALING;
        }
        PageableScene pageableScene = new PageableScene(scene, pageFormat, scaleStrategy, d, d2, bl, bl2, rectangle);
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPageable(pageableScene);
        if (printerJob.printDialog()) {
            try {
                Object object3;
                ArrayList<Widget> arrayList = new ArrayList<Widget>();
                if (list != null && list.size() > 0) {
                    for (LayerWidget iterator2 : list) {
                        iterator2.setVisible(false);
                        arrayList.add(iterator2);
                    }
                }
                if (bl && scene instanceof ObjectScene) {
                    object3 = (ObjectScene)scene;
                    HashSet hashSet = new HashSet();
                    hashSet.addAll(((ObjectScene)object3).getObjects());
                    Set<?> set = ((ObjectScene)object3).getSelectedObjects();
                    hashSet.removeAll(set);
                    for (Object e : hashSet) {
                        Widget widget = ((ObjectScene)object3).findWidget(e);
                        if (widget == null || !widget.isVisible()) continue;
                        widget.setVisible(false);
                        arrayList.add(widget);
                    }
                }
                if (bl2 || rectangle != null) {
                    if (rectangle == null) {
                        rectangle = scene.getView().getVisibleRect();
                    }
                    object3 = new ArrayList();
                    for (Widget widget : scene.getChildren()) {
                        object3.addAll(ScenePrinter.getAllNodeWidgets(widget, null));
                    }
                    Iterator iterator = object3.iterator();
                    while (iterator.hasNext()) {
                        Widget widget = (Widget)iterator.next();
                        Rectangle rectangle2 = widget.convertLocalToScene(widget.getBounds());
                        boolean bl3 = rectangle.contains(rectangle2);
                        if (bl3 || !widget.isVisible()) continue;
                        widget.setVisible(false);
                        arrayList.add(widget);
                    }
                }
                printerJob.print();
                for (Widget widget : arrayList) {
                    widget.setVisible(true);
                }
                scene.validate();
            }
            catch (PrinterException printerException) {
                System.out.println("Error printing: " + printerException);
            }
        }
    }

    private static List<Widget> getAllNodeWidgets(Widget widget, List<Widget> list) {
        if (list == null) {
            list = new ArrayList<Widget>();
        }
        if (widget instanceof LayerWidget && widget.getChildren().size() > 0) {
            list.addAll(widget.getChildren());
            for (Widget widget2 : widget.getChildren()) {
                ScenePrinter.getAllNodeWidgets(widget2, list);
            }
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScaleStrategy {
        SCALE_CURRENT_ZOOM,
        SCALE_PERCENT,
        SCALE_TO_FIT,
        SCALE_TO_FIT_X,
        SCALE_TO_FIT_Y,
        NO_SCALING;

    }
}

