/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.filter;

import ca.odell.glazedlists.impl.filter.AbstractTextSearchStrategy;

public class SingleCharacterCaseInsensitiveTextSearchStrategy
extends AbstractTextSearchStrategy {
    private char subtextCharLower;
    private char subtextCharUpper;
    private boolean subtextInitialized = false;

    public void setSubtext(String subtext) {
        if (subtext == null) {
            throw new IllegalArgumentException("subtext may not be null");
        }
        if (subtext.length() != 1) {
            throw new IllegalArgumentException("subtext (" + subtext + ") must contain a single character");
        }
        char c = subtext.charAt(0);
        this.subtextCharLower = Character.toLowerCase(c);
        this.subtextCharUpper = Character.toUpperCase(c);
        this.subtextInitialized = true;
    }

    public int indexOf(String text) {
        if (!this.subtextInitialized) {
            throw new IllegalStateException("setSubtext must be called with a valid value before this method can operate");
        }
        for (int i = 0; i < text.length(); ++i) {
            char firstChar = this.map(text.charAt(i));
            if (firstChar != this.subtextCharLower && firstChar != this.subtextCharUpper) continue;
            return i;
        }
        return -1;
    }
}

