/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.UpdateSelectionAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTaskList;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.swing.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class UpdateDataAction
extends JosmAction {
    public UpdateDataAction() {
        super(I18n.tr("Update data", new Object[0]), "updatedata", I18n.tr("Updates the objects in the active data layer from the server.", new Object[0]), Shortcut.registerShortcut("file:updatedata", I18n.tr("File: {0}", I18n.tr("Update data", new Object[0])), 85, 5006), true);
        this.setHelpId(HelpUtil.ht("/Action/UpdateData"));
    }

    @Override
    protected void updateEnabledState() {
        OsmDataLayer editLayer = this.getLayerManager().getEditLayer();
        this.setEnabled(editLayer != null && editLayer.isDownloadable() && !NetworkManager.isOffline(OnlineResource.OSM_API));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i;
        OsmDataLayer editLayer = this.getLayerManager().getEditLayer();
        if (!this.isEnabled() || editLayer == null || !editLayer.isDownloadable()) {
            return;
        }
        ArrayList<Area> areas = new ArrayList<Area>();
        for (DataSource ds : editLayer.data.getDataSources()) {
            areas.add(new Area(ds.bounds.asRect()));
        }
        for (i = 0; i < areas.size(); ++i) {
            for (int j = i + 1; j < areas.size(); ++j) {
                ((Area)areas.get(i)).subtract((Area)areas.get(j));
            }
        }
        for (i = areas.size() - 1; i > 0; --i) {
            for (int j = i - 1; j > 0; --j) {
                ((Area)areas.get(i)).subtract((Area)areas.get(j));
            }
        }
        ArrayList<Area> areasToDownload = new ArrayList<Area>();
        for (Area a : areas) {
            if (a.isEmpty()) continue;
            areasToDownload.add(a);
        }
        if (areasToDownload.isEmpty()) {
            UpdateSelectionAction.updatePrimitives(editLayer.data.allPrimitives());
        } else {
            PleaseWaitProgressMonitor monitor = new PleaseWaitProgressMonitor(I18n.tr("Download data", new Object[0]));
            Future<?> future = new DownloadTaskList().download(false, (Collection<Area>)areasToDownload, true, false, (ProgressMonitor)monitor);
            UpdateDataAction.waitFuture(future, monitor);
        }
    }
}

