/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions.mods;

import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.BaseInvokeNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.InvokeNode;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import org.jetbrains.annotations.Nullable;

public final class ConstructorInsn
extends BaseInvokeNode {
    private final MethodInfo callMth;
    private final CallType callType;

    public ConstructorInsn(MethodNode mth, InvokeNode invoke) {
        super(InsnType.CONSTRUCTOR, invoke.getArgsCount() - 1);
        this.callMth = invoke.getCallMth();
        this.callType = this.getCallType(mth, this.callMth.getDeclClass(), invoke.getArg(0));
        int argsCount = invoke.getArgsCount();
        for (int i = 1; i < argsCount; ++i) {
            this.addArg(invoke.getArg(i));
        }
    }

    private CallType getCallType(MethodNode mth, ClassInfo classType, InsnArg instanceArg) {
        if (!instanceArg.isThis()) {
            return CallType.CONSTRUCTOR;
        }
        if (!classType.equals(mth.getParentClass().getClassInfo())) {
            return CallType.SUPER;
        }
        if (this.callMth.getShortId().equals(mth.getMethodInfo().getShortId())) {
            return CallType.SELF;
        }
        return CallType.THIS;
    }

    public ConstructorInsn(MethodInfo callMth, CallType callType) {
        super(InsnType.CONSTRUCTOR, callMth.getArgsCount());
        this.callMth = callMth;
        this.callType = callType;
    }

    @Override
    public MethodInfo getCallMth() {
        return this.callMth;
    }

    @Override
    @Nullable
    public RegisterArg getInstanceArg() {
        return null;
    }

    public ClassInfo getClassType() {
        return this.callMth.getDeclClass();
    }

    public CallType getCallType() {
        return this.callType;
    }

    public boolean isNewInstance() {
        return this.callType == CallType.CONSTRUCTOR;
    }

    public boolean isSuper() {
        return this.callType == CallType.SUPER;
    }

    public boolean isThis() {
        return this.callType == CallType.THIS;
    }

    public boolean isSelf() {
        return this.callType == CallType.SELF;
    }

    @Override
    public boolean isStaticCall() {
        return false;
    }

    @Override
    public int getFirstArgOffset() {
        return 0;
    }

    @Override
    public boolean isSame(InsnNode obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConstructorInsn) || !super.isSame(obj)) {
            return false;
        }
        ConstructorInsn other = (ConstructorInsn)obj;
        return this.callMth.equals(other.callMth) && this.callType == other.callType;
    }

    @Override
    public InsnNode copy() {
        return this.copyCommonParams(new ConstructorInsn(this.callMth, this.callType));
    }

    @Override
    public String toString() {
        return super.toString() + " call: " + this.callMth + " type: " + (Object)((Object)this.callType);
    }

    public static enum CallType {
        CONSTRUCTOR,
        SUPER,
        THIS,
        SELF;

    }
}

