/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;

public abstract class CombatModel {
    protected final boolean combatIsAttackMeasurement(FreeColGameObject attacker, FreeColGameObject defender) {
        return attacker instanceof Unit && defender == null;
    }

    protected final boolean combatIsDefenceMeasurement(FreeColGameObject attacker, FreeColGameObject defender) {
        return attacker == null && defender instanceof Unit;
    }

    public boolean combatIsAttack(FreeColGameObject attacker, FreeColGameObject defender) {
        return attacker instanceof Unit && defender instanceof Unit;
    }

    public boolean combatIsSettlementAttack(FreeColGameObject attacker, FreeColGameObject defender) {
        return attacker instanceof Unit && defender instanceof Settlement;
    }

    public boolean combatIsBombard(FreeColGameObject attacker, FreeColGameObject defender) {
        return attacker instanceof Settlement && defender instanceof Unit && ((Unit)defender).isNaval();
    }

    public boolean combatIsAmphibious(FreeColGameObject attacker, FreeColGameObject defender) {
        return attacker instanceof Unit && ((Unit)attacker).hasTile() && !((Unit)attacker).getTile().isLand() && defender instanceof Location && ((Location)((Object)defender)).getTile() != null && ((Location)((Object)defender)).getTile().isLand();
    }

    protected final boolean combatIsWarOfIndependence(FreeColGameObject attacker, FreeColGameObject defender) {
        if (attacker instanceof Unit && defender instanceof Ownable) {
            Player aPlayer = ((Unit)attacker).getOwner();
            Player dPlayer = ((Ownable)((Object)defender)).getOwner();
            return aPlayer.isRebel() && aPlayer.getREFPlayer() == dPlayer || dPlayer.isRebel() && dPlayer.getREFPlayer() == aPlayer;
        }
        return false;
    }

    public final Comparator<Unit> getMilitaryStrengthComparator() {
        return (u1, u2) -> Double.compare(this.calculateCombatOdds((FreeColGameObject)u1, (FreeColGameObject)u2).win, this.calculateCombatOdds((FreeColGameObject)u2, (FreeColGameObject)u1).win);
    }

    public abstract CombatOdds calculateCombatOdds(FreeColGameObject var1, FreeColGameObject var2);

    public abstract double getOffencePower(FreeColGameObject var1, FreeColGameObject var2);

    public abstract double getDefencePower(FreeColGameObject var1, FreeColGameObject var2);

    public abstract Set<Modifier> getOffensiveModifiers(FreeColGameObject var1, FreeColGameObject var2);

    public abstract Set<Modifier> getDefensiveModifiers(FreeColGameObject var1, FreeColGameObject var2);

    public abstract CombatResult generateAttackResult(Random var1, FreeColGameObject var2, FreeColGameObject var3);

    public static class CombatOdds {
        public static final double UNKNOWN_ODDS = -1.0;
        public final double win;

        public CombatOdds(double win) {
            this.win = win;
        }
    }

    public static final class CombatResult {
        private final List<CombatEffectType> effects;
        private final int attackerHitpointsAfter;
        private final int defenderHitpointsAfter;

        public CombatResult(List<CombatEffectType> effects) {
            this.effects = Objects.requireNonNull(effects);
            this.attackerHitpointsAfter = -1;
            this.defenderHitpointsAfter = -1;
        }

        public CombatResult(List<CombatEffectType> effects, int attackerHitpointsAfter, int defenderHitpointsAfter) {
            this.effects = Objects.requireNonNull(effects);
            this.attackerHitpointsAfter = attackerHitpointsAfter;
            this.defenderHitpointsAfter = defenderHitpointsAfter;
        }

        public List<CombatEffectType> getEffects() {
            return this.effects;
        }

        public boolean isAttackerHitpointsAffected() {
            return this.attackerHitpointsAfter >= 0;
        }

        public boolean isDefenderHitpointsAffected() {
            return this.defenderHitpointsAfter >= 0;
        }

        public int getAttackerHitpointsAfter() {
            return this.attackerHitpointsAfter;
        }

        public int getDefenderHitpointsAfter() {
            return this.defenderHitpointsAfter;
        }
    }

    public static enum CombatEffectType {
        NO_RESULT,
        LOSE,
        WIN,
        AUTOEQUIP_UNIT,
        BURN_MISSIONS,
        CAPTURE_AUTOEQUIP,
        CAPTURE_COLONY,
        CAPTURE_CONVERT,
        CAPTURE_EQUIP,
        CAPTURE_UNIT,
        DAMAGE_COLONY_SHIPS,
        DAMAGE_SHIP_ATTACK,
        DAMAGE_SHIP_BOMBARD,
        DEMOTE_UNIT,
        DESTROY_COLONY,
        DESTROY_SETTLEMENT,
        EVADE_ATTACK,
        EVADE_BOMBARD,
        LOOT_SHIP,
        LOSE_AUTOEQUIP,
        LOSE_EQUIP,
        PILLAGE_COLONY,
        PROMOTE_UNIT,
        SINK_COLONY_SHIPS,
        SINK_SHIP_ATTACK,
        SINK_SHIP_BOMBARD,
        SLAUGHTER_UNIT;

    }
}

