/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.vfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Comparator;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.impl.DefaultFileSystemManager;
import org.apache.commons.vfs.provider.local.LocalFile;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.util.UUIDUtil;
import org.pentaho.di.core.vfs.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KettleVFS {
    private static KettleVFS kettleVFS;

    private KettleVFS() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    FileSystemManager mgr = VFS.getManager();
                    if (mgr instanceof DefaultFileSystemManager) {
                        ((DefaultFileSystemManager)mgr).close();
                    }
                }
                catch (FileSystemException e) {
                    e.printStackTrace();
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(thread);
    }

    private static synchronized void checkHook() {
        if (kettleVFS == null) {
            kettleVFS = new KettleVFS();
        }
    }

    public static FileObject getFileObject(String vfsFilename) throws IOException {
        KettleVFS.checkHook();
        try {
            String filename;
            File file;
            FileSystemManager fsManager = VFS.getManager();
            boolean relativeFilename = true;
            String[] schemes = VFS.getManager().getSchemes();
            for (int i = 0; i < schemes.length && relativeFilename; ++i) {
                if (!vfsFilename.startsWith(schemes[i] + ":")) continue;
                relativeFilename = false;
            }
            if (vfsFilename.startsWith("\\\\")) {
                file = new File(vfsFilename);
                filename = file.toURI().toString();
            } else if (relativeFilename) {
                file = new File(vfsFilename);
                filename = file.getAbsolutePath();
            } else {
                filename = vfsFilename;
            }
            FileObject fileObject = fsManager.resolveFile(filename);
            return fileObject;
        }
        catch (IOException e) {
            throw new IOException("Unable to get VFS File object for filename '" + vfsFilename + "' : " + e.toString());
        }
    }

    public static String getTextFileContent(String vfsFilename, String charSetName) throws IOException {
        int c;
        InputStream inputStream = KettleVFS.getInputStream(vfsFilename);
        InputStreamReader reader = new InputStreamReader(inputStream, charSetName);
        StringBuffer stringBuffer = new StringBuffer();
        while ((c = reader.read()) != -1) {
            stringBuffer.append((char)c);
        }
        reader.close();
        inputStream.close();
        return stringBuffer.toString();
    }

    public static boolean fileExists(String vfsFilename) throws IOException {
        FileObject fileObject = KettleVFS.getFileObject(vfsFilename);
        return fileObject.exists();
    }

    public static InputStream getInputStream(FileObject fileObject) throws FileSystemException {
        FileContent content = fileObject.getContent();
        return content.getInputStream();
    }

    public static InputStream getInputStream(String vfsFilename) throws IOException {
        FileObject fileObject = KettleVFS.getFileObject(vfsFilename);
        return KettleVFS.getInputStream(fileObject);
    }

    public static OutputStream getOutputStream(FileObject fileObject, boolean append) throws IOException {
        FileObject parent = fileObject.getParent();
        if (parent != null && !parent.exists()) {
            throw new IOException(Messages.getString("KettleVFS.Exception.ParentDirectoryDoesNotExist", KettleVFS.getFilename(parent)));
        }
        try {
            fileObject.createFile();
            FileContent content = fileObject.getContent();
            return content.getOutputStream(append);
        }
        catch (FileSystemException e) {
            if (fileObject instanceof LocalFile) {
                try {
                    String filename = KettleVFS.getFilename(fileObject);
                    return new FileOutputStream(new File(filename), append);
                }
                catch (Exception e2) {
                    throw e;
                }
            }
            throw e;
        }
    }

    public static OutputStream getOutputStream(String vfsFilename, boolean append) throws IOException {
        FileObject fileObject = KettleVFS.getFileObject(vfsFilename);
        return KettleVFS.getOutputStream(fileObject, append);
    }

    public static String getFilename(FileObject fileObject) {
        FileName fileName = fileObject.getName();
        String root = fileName.getRootURI();
        if (!root.startsWith("file:")) {
            return fileName.getURI();
        }
        root = root.endsWith(":/") ? root.substring(8, 10) : "";
        String fileString = root + fileName.getPath();
        if (!"/".equals(Const.FILE_SEPARATOR)) {
            fileString = Const.replace(fileString, "/", Const.FILE_SEPARATOR);
        }
        return fileString;
    }

    public static FileObject createTempFile(String prefix, String suffix, String directory) throws IOException {
        String filename;
        FileObject fileObject;
        while ((fileObject = KettleVFS.getFileObject(filename = new StringBuffer(50).append(directory).append('/').append(prefix).append('_').append(UUIDUtil.getUUIDAsString()).append(suffix).toString())).exists()) {
        }
        return fileObject;
    }

    public static Comparator<FileObject> getComparator() {
        return new Comparator<FileObject>(){

            @Override
            public int compare(FileObject o1, FileObject o2) {
                String filename1 = KettleVFS.getFilename(o1);
                String filename2 = KettleVFS.getFilename(o2);
                return filename1.compareTo(filename2);
            }
        };
    }

    public static FileInputStream getFileInputStream(FileObject fileObject) throws IOException {
        if (!(fileObject instanceof LocalFile)) {
            throw new IOException(Messages.getString("FixedInput.Log.OnlyLocalFilesAreSupported"));
        }
        return new FileInputStream(fileObject.getName().getPathDecoded());
    }
}

