# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx.logical_routers.service_cluster.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class State(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.logical_routers.service_cluster.state'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _StateStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            logical_router_id,
            barrier_id=None,
            request_id=None,
            ):
        """
        Return realized state information of a logical service router cluster.
        Any configuration update that affects the logical service router
        cluster can use this API to get its realized state by passing a
        request_id returned by the configuration change operation. e.g. Update
        configuration of nat, bgp, bfd, etc. What is a Service Router? When a
        service cannot be distributed is enabled on a Logical Router, a Service
        Router (SR) is instantiated. Some examples of services that are not
        distributed are NAT, DHCP server, Metadata Proxy, Edge Firewall, Load
        Balancer and so on. 
        
        Please use below policy apis instead of this API. 
        GET /infra/tier-0s/<tier-0-id>/state 
        GET /infra/tier-1s/<tier-1-id>/state 

        .. deprecated:: unknown

        :type  logical_router_id: :class:`str`
        :param logical_router_id: (required)
        :type  barrier_id: :class:`long` or ``None``
        :param barrier_id: (optional)
        :type  request_id: :class:`str` or ``None``
        :param request_id: Realization request ID (optional)
        :rtype: :class:`com.vmware.nsx.model_client.LogicalServiceRouterClusterState`
        :return: com.vmware.nsx.model.LogicalServiceRouterClusterState
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx.logical_routers.service_cluster.State.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'logical_router_id': logical_router_id,
                            'barrier_id': barrier_id,
                            'request_id': request_id,
                            })
class _StateStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'logical_router_id': type.StringType(),
            'barrier_id': type.OptionalType(type.IntegerType()),
            'request_id': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/logical-routers/{logical-router-id}/service-cluster/state',
            path_variables={
                'logical_router_id': 'logical-router-id',
            },
             header_parameters={
                   },
            query_parameters={
                'barrier_id': 'barrier_id',
                'request_id': 'request_id',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'LogicalServiceRouterClusterState'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.logical_routers.service_cluster.state',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'State': State,
    }

