/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.utils;

import java.util.Arrays;
import java.util.Comparator;
import javax.swing.SortOrder;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;

abstract class SortedObjectsBuffer<T> {
    private final int cacheSize;
    private long totalObjects;
    private final Wrapper<T>[] elements;
    private final boolean sorting;
    private final boolean ascending;
    private final DataType dataType;
    private final Heap heap;
    private final HeapViewerNode parent;
    private final HeapViewerNodeFilter filter;
    private boolean notFull;
    private int currentIndex;
    private final T previousObject;
    private boolean previousObjectSeen;
    private final Object previousObjectValue;
    private Object maxObjectValue;
    private int wrapperSerialId;

    SortedObjectsBuffer(int nodesCount, T previousObject, DataType dataType, SortOrder sortOrder, HeapViewerNodeFilter filter, Heap heap, HeapViewerNode parent) {
        this.cacheSize = nodesCount;
        this.elements = new Wrapper[this.cacheSize * 2];
        this.sorting = sortOrder != null && !SortOrder.UNSORTED.equals((Object)sortOrder) && dataType != null && this.sorts(dataType);
        this.ascending = SortOrder.ASCENDING.equals((Object)sortOrder);
        this.dataType = dataType;
        this.heap = heap;
        this.parent = parent;
        this.filter = filter;
        this.notFull = true;
        this.currentIndex = -1;
        this.previousObject = previousObject;
        this.previousObjectSeen = previousObject == null;
        this.previousObjectValue = this.previousObjectSeen ? null : HeapViewerNode.getValue(this.createNode(previousObject), dataType, heap, parent);
    }

    protected abstract boolean sorts(DataType var1);

    protected abstract HeapViewerNode createNode(T var1);

    void add(T object) {
        int comp;
        HeapViewerNode node = this.createNode(object);
        if (this.filter != null && !this.filter.passes(node, this.heap)) {
            return;
        }
        ++this.totalObjects;
        if (!this.sorting) {
            if (this.notFull) {
                ++this.currentIndex;
                this.elements[this.currentIndex] = this.createWrapper(object, null);
                if (this.currentIndex == this.cacheSize - 1) {
                    this.notFull = false;
                }
            }
            return;
        }
        Object value = HeapViewerNode.getValue(node, this.dataType, this.heap, this.parent);
        if (this.previousObjectValue != null) {
            comp = this.compare(value, this.previousObjectValue);
            if (comp < 0) {
                return;
            }
            if (comp == 0 && !this.previousObjectSeen) {
                if (this.previousObject.equals(object)) {
                    this.previousObjectSeen = true;
                }
                return;
            }
        }
        if (this.maxObjectValue != null && (comp = this.compare(value, this.maxObjectValue)) >= 0) {
            return;
        }
        ++this.currentIndex;
        this.elements[this.currentIndex] = this.createWrapper(object, value);
        if (this.currentIndex < this.elements.length - 1) {
            return;
        }
        Arrays.sort(this.elements, new WrapperComparator());
        int middleIndex = this.elements.length / 2 - 1;
        this.maxObjectValue = ((Wrapper)this.elements[middleIndex]).value;
        this.currentIndex = middleIndex;
    }

    T[] getObjects() {
        if (this.sorting) {
            Arrays.fill(this.elements, this.currentIndex + 1, this.elements.length - 1, null);
            Arrays.sort(this.elements, new WrapperComparator());
        }
        int size = Math.min(this.currentIndex + 1, this.elements.length / 2);
        Object[] objects = new Object[size];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = ((Wrapper)this.elements[i]).object;
        }
        return objects;
    }

    long getTotalObjects() {
        return this.totalObjects;
    }

    private Wrapper<T> createWrapper(T obj, Object val) {
        return new Wrapper(this.wrapperSerialId++, obj, val);
    }

    private int compare(Object value1, Object value2) {
        if (value1 == value2) {
            return 0;
        }
        if (value1 == null) {
            return this.ascending ? -1 : 1;
        }
        if (value2 == null) {
            return this.ascending ? 1 : -1;
        }
        return ((Comparable)value1).compareTo(value2) * (this.ascending ? 1 : -1);
    }

    private static class Wrapper<T> {
        private final T object;
        private final Object value;
        private final int serialId;

        private Wrapper(int id, T obj, Object val) {
            this.serialId = id;
            this.object = obj;
            this.value = val;
        }
    }

    private class WrapperComparator
    implements Comparator<Wrapper<T>> {
        private WrapperComparator() {
        }

        @Override
        public int compare(Wrapper<T> o1, Wrapper<T> o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            int comp = SortedObjectsBuffer.this.compare(o1.value, o2.value);
            if (comp == 0) {
                if (o1.serialId > o2.serialId) {
                    return 1;
                }
                if (o1.serialId < o2.serialId) {
                    return -1;
                }
            }
            return comp;
        }
    }
}

