/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;
import org.traccar.session.DeviceSession;

public class FifotrackProtocolDecoder
extends BaseProtocolDecoder {
    private ByteBuf photo;
    private static final Pattern PATTERN = new PatternBuilder().text("$$").number("d+,").number("(d+),").number("x+,").expression("[^,]+,").number("(d+)?,").number("(dd)(dd)(dd)").number("(dd)(dd)(dd),").number("([AV]),").number("(-?d+.d+),").number("(-?d+.d+),").number("(d+),").number("(d+),").number("(-?d+),").number("(d+),").number("(d+),").number("(x+),").number("(x+)?,").number("(x+)?,").number("(d+)|").number("(d+)|").number("(x+)|").number("(x+),").number("([x|]+)").expression(",([^,]+)").expression(",([^*]*)").optional(2).any().compile();
    private static final Pattern PATTERN_NEW = new PatternBuilder().text("$$").number("d+,").number("(d+),").number("(x+),").text("A03,").number("(d+)?,").number("(dd)(dd)(dd)").number("(dd)(dd)(dd),").number("(d+)|").number("(d+)|").number("(x+)|").number("(x+),").number("(d+.d+),").number("(d+),").number("(x+),").groupBegin().text("0,").number("([AV]),").number("(d+),").number("(d+),").number("(-?d+.d+),").number("(-?d+.d+)").or().text("1,").expression("([^*]+)").groupEnd().text("*").number("xx").compile();
    private static final Pattern PATTERN_PHOTO = new PatternBuilder().text("$$").number("d+,").number("(d+),").any().number(",(d+),").expression("([^*]+)").text("*").number("xx").compile();
    private static final Pattern PATTERN_PHOTO_DATA = new PatternBuilder().text("$$").number("d+,").number("(d+),").number("x+,").expression("[^,]+,").expression("([^,]+),").number("(d+),").number("(d+),").compile();
    private static final Pattern PATTERN_RESULT = new PatternBuilder().text("$$").number("d+,").number("(d+),").any().expression(",([A-Z]+)").text("*").number("xx").compile();

    public FifotrackProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, String imei, String content) {
        if (channel != null) {
            int length = 1 + imei.length() + 1 + content.length();
            Object response = String.format("##%02d,%s,%s*", length, imei, content);
            response = (String)response + Checksum.sum((String)response) + "\r\n";
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    private void requestPhoto(Channel channel, SocketAddress remoteAddress, String imei, String file) {
        String content = "1,D06," + file + "," + this.photo.writerIndex() + "," + Math.min(1024, this.photo.writableBytes());
        this.sendResponse(channel, remoteAddress, imei, content);
    }

    private String decodeAlarm(Integer alarm) {
        if (alarm != null) {
            return switch (alarm) {
                case 2 -> "sos";
                case 14 -> "lowPower";
                case 15 -> "powerCut";
                case 16 -> "powerRestored";
                case 17 -> "lowBattery";
                case 18 -> "overspeed";
                case 20 -> "gpsAntennaCut";
                case 21 -> "vibration";
                case 23 -> "hardAcceleration";
                case 24 -> "hardBraking";
                case 27 -> "fatigueDriving";
                case 30, 32 -> "jamming";
                case 31 -> "fallDown";
                case 33 -> "geofenceExit";
                case 34 -> "geofenceEnter";
                case 35 -> "idle";
                case 40, 41 -> "temperature";
                case 53 -> "powerOn";
                case 54 -> "powerOff";
                default -> null;
            };
        }
        return null;
    }

    private Object decodeLocationNew(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_NEW, sentence);
        if (!parser.matches()) {
            return null;
        }
        String imei = parser.next();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        String index = parser.next();
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.addAlarm(this.decodeAlarm(parser.nextInt()));
        position.setDeviceTime(parser.nextDateTime());
        Network network = new Network();
        network.addCellTower(CellTower.from(parser.nextInt(), parser.nextInt(), parser.nextHexInt(), parser.nextHexInt().intValue()));
        position.set("battery", parser.nextDouble());
        position.set("batteryLevel", parser.nextInt());
        position.set("status", parser.nextHexInt());
        if (parser.hasNext(5)) {
            position.setValid(parser.next().equals("A"));
            position.setFixTime(position.getDeviceTime());
            position.setSpeed(UnitsConverter.knotsFromKph(parser.nextInt().intValue()));
            position.set("sat", parser.nextInt());
            position.setLatitude(parser.nextDouble());
            position.setLongitude(parser.nextDouble());
        } else {
            String[] points;
            this.getLastLocation(position, position.getDeviceTime());
            for (String point : points = parser.next().split("\\|")) {
                String[] wifi = point.split(":");
                String mac = wifi[0].replaceAll("(..)", "$1:");
                network.addWifiAccessPoint(WifiAccessPoint.from(mac.substring(0, mac.length() - 1), Integer.parseInt(wifi[1])));
            }
        }
        position.setNetwork(network);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmmss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String response = index + ",A03," + dateFormat.format(new Date());
        this.sendResponse(channel, remoteAddress, imei, response);
        return position;
    }

    private Object decodeLocation(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.addAlarm(this.decodeAlarm(parser.nextInt()));
        position.setTime(parser.nextDateTime());
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextDouble());
        position.setLongitude(parser.nextDouble());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextInt().intValue()));
        position.setCourse(parser.nextInt().intValue());
        position.setAltitude(parser.nextInt().intValue());
        position.set("odometer", parser.nextLong());
        position.set("hours", parser.nextLong() * 1000L);
        long status = parser.nextHexLong();
        position.set("rssi", BitUtil.between(status, 3, 8));
        position.set("sat", BitUtil.from(status, 28));
        position.set("status", status);
        position.set("input", parser.nextHexInt());
        position.set("output", parser.nextHexInt());
        position.setNetwork(new Network(CellTower.from(parser.nextInt(), parser.nextInt(), parser.nextHexInt(), parser.nextHexInt().intValue())));
        String[] adc = parser.next().split("\\|");
        for (int i = 0; i < adc.length; ++i) {
            position.set("adc" + (i + 1), Integer.parseInt(adc[i], 16));
        }
        if (parser.hasNext()) {
            String value = parser.next();
            if (value.matches("\\p{XDigit}+")) {
                position.set("driverUniqueId", String.valueOf(Integer.parseInt(value, 16)));
            } else {
                position.set("card", value);
            }
        }
        if (parser.hasNext()) {
            String[] sensors = parser.next().split("\\|");
            for (int i = 0; i < sensors.length; ++i) {
                position.set("io" + (i + 1), sensors[i]);
            }
        }
        return position;
    }

    private Object decodeResult(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_RESULT, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("result", parser.next());
        return position;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        int typeIndex = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)44) + 1;
        typeIndex = buf.indexOf(typeIndex, buf.writerIndex(), (byte)44) + 1;
        String type = buf.toString(typeIndex = buf.indexOf(typeIndex, buf.writerIndex(), (byte)44) + 1, 3, StandardCharsets.US_ASCII);
        if (type.startsWith("B")) {
            return this.decodeResult(channel, remoteAddress, buf.toString(StandardCharsets.US_ASCII));
        }
        if (type.equals("D05")) {
            String sentence = buf.toString(StandardCharsets.US_ASCII);
            Parser parser = new Parser(PATTERN_PHOTO, sentence);
            if (!parser.matches()) return null;
            String imei = parser.next();
            int length = parser.nextInt();
            String photoId = parser.next();
            this.photo = Unpooled.buffer((int)length);
            this.requestPhoto(channel, remoteAddress, imei, photoId);
            return null;
        }
        if (!type.equals("D06")) {
            if (!type.equals("A03")) return this.decodeLocation(channel, remoteAddress, buf.toString(StandardCharsets.US_ASCII));
            return this.decodeLocationNew(channel, remoteAddress, buf.toString(StandardCharsets.US_ASCII));
        }
        if (this.photo == null) {
            return null;
        }
        int dataIndex = buf.indexOf(typeIndex + 4, buf.writerIndex(), (byte)44) + 1;
        dataIndex = buf.indexOf(dataIndex, buf.writerIndex(), (byte)44) + 1;
        dataIndex = buf.indexOf(dataIndex, buf.writerIndex(), (byte)44) + 1;
        String sentence = buf.toString(buf.readerIndex(), dataIndex, StandardCharsets.US_ASCII);
        Parser parser = new Parser(PATTERN_PHOTO_DATA, sentence);
        if (!parser.matches()) return null;
        String imei = parser.next();
        String photoId = parser.next();
        parser.nextInt();
        parser.nextInt();
        buf.readerIndex(dataIndex);
        buf.readBytes(this.photo, buf.readableBytes() - 3);
        if (this.photo.isWritable()) {
            this.requestPhoto(channel, remoteAddress, imei, photoId);
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(this.getDeviceSession(channel, remoteAddress, imei).getDeviceId());
        this.getLastLocation(position, null);
        position.set("image", this.writeMediaFile(imei, this.photo, "jpg"));
        this.photo.release();
        this.photo = null;
        return position;
    }
}

