/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class DwayProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("AA55,").number("d+,").number("(d+),").number("d+,").number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").number("(-?d+.d+),").number("(-?d+.d+),").number("(-?d+),").number(" ?(d+.d+),").number("(d+),").number("([01]{4}),").number("([01]{4}),").number("([01]+),").number("(d+),").number("(d+),").number("(d+),").number("(d+)").any().compile();

    public DwayProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        if (sentence.equals("AA55,HB")) {
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage("55AA,HB,OK\r\n", remoteAddress));
            }
            return null;
        }
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setValid(true);
        position.setTime(parser.nextDateTime());
        position.setLatitude(parser.nextDouble());
        position.setLongitude(parser.nextDouble());
        position.setAltitude(parser.nextDouble(0.0));
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble(0.0)));
        position.setCourse(parser.nextDouble(0.0));
        position.set("input", parser.nextBinInt());
        position.set("output", parser.nextBinInt());
        position.set("battery", (double)parser.nextInt().intValue() * 0.001);
        position.set("adc1", (double)parser.nextInt().intValue() * 0.001);
        position.set("adc2", (double)parser.nextInt().intValue() * 0.001);
        position.set("driverUniqueId", parser.next());
        return position;
    }
}

