/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.expr.FunctionBase;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.expr.PropertyInfo;
import org.apache.fop.fo.properties.ColorProperty;
import org.apache.fop.fo.properties.Property;

class RGBColorFunction
extends FunctionBase {
    RGBColorFunction() {
    }

    public int nbArgs() {
        return 3;
    }

    public PercentBase getPercentBase() {
        return new RGBPercentBase();
    }

    public Property eval(Property[] args, PropertyInfo pInfo) throws PropertyException {
        FOUserAgent ua = pInfo == null ? null : (pInfo.getFO() == null ? null : pInfo.getFO().getUserAgent());
        return new ColorProperty(ua, "rgb(" + args[0] + "," + args[1] + "," + args[2] + ")");
    }

    static class RGBPercentBase
    implements PercentBase {
        RGBPercentBase() {
        }

        public int getDimension() {
            return 0;
        }

        public double getBaseValue() {
            return 255.0;
        }

        public int getBaseLength(PercentBaseContext context) {
            return 0;
        }
    }
}

