/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.base.JRBaseElementGroup;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;

public class JRBaseBand
extends JRBaseElementGroup
implements JRBand,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_SPLIT_ALLOWED = "splitAllowed";
    protected int height = 0;
    protected boolean isSplitAllowed = true;
    protected JRExpression printWhenExpression = null;
    private transient JRPropertyChangeSupport eventSupport;

    protected JRBaseBand(JRBand band, JRBaseObjectFactory factory) {
        super(band, factory);
        this.height = band.getHeight();
        this.isSplitAllowed = band.isSplitAllowed();
        this.printWhenExpression = factory.getExpression(band.getPrintWhenExpression());
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isSplitAllowed() {
        return this.isSplitAllowed;
    }

    public void setSplitAllowed(boolean isSplitAllowed) {
        boolean old = this.isSplitAllowed;
        this.isSplitAllowed = isSplitAllowed;
        this.getEventSupport().firePropertyChange(PROPERTY_SPLIT_ALLOWED, old, this.isSplitAllowed);
    }

    public JRExpression getPrintWhenExpression() {
        return this.printWhenExpression;
    }

    public Object clone() {
        JRBaseBand clone = (JRBaseBand)super.clone();
        if (this.printWhenExpression != null) {
            clone.printWhenExpression = (JRExpression)this.printWhenExpression.clone();
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseBand jRBaseBand = this;
        synchronized (jRBaseBand) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }
}

