/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0lf + dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)) => dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)
 * (0.0lf + dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf)) => dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf)
 * (-1.3333333333333333lf + dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)) => dvec4(-2.9833333333333334lf, -0.0033333333333331883lf, 0.5966666666666667lf, -0.5733333333333333lf)
 * (-1.3333333333333333lf + dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf)) => dvec4(-0.5333333333333332lf, -1.4833333333333332lf, -1.8433333333333333lf, -1.3333333333333333lf)
 * (0.85lf + dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)) => dvec4(-0.7999999999999999lf, 2.18lf, 2.78lf, 1.6099999999999999lf)
 * (0.85lf + dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf)) => dvec4(1.65lf, 0.7lf, 0.33999999999999997lf, 0.85lf)
 */
#version 400

void main()
{
  double[distance((0.0lf + dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)), dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)) <= 2.9654510618116767e-05lf ? 1 : -1] array0;
  double[distance((0.0lf + dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf)), dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf)) <= 9.605206921248497e-06lf ? 1 : -1] array1;
  double[distance((-1.3333333333333333lf + dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)), dvec4(-2.9833333333333334lf, -0.0033333333333331883lf, 0.5966666666666667lf, -0.5733333333333333lf)) <= 3.0959669105323325e-05lf ? 1 : -1] array2;
  double[distance((-1.3333333333333333lf + dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf)), dvec4(-0.5333333333333332lf, -1.4833333333333332lf, -1.8433333333333333lf, -1.3333333333333333lf)) <= 2.7677387481078808e-05lf ? 1 : -1] array3;
  double[distance((0.85lf + dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)), dvec4(-0.7999999999999999lf, 2.18lf, 2.78lf, 1.6099999999999999lf)) <= 3.963950050139381e-05lf ? 1 : -1] array4;
  double[distance((0.85lf + dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf)), dvec4(1.65lf, 0.7lf, 0.33999999999999997lf, 0.85lf)) <= 2.012610245427564e-05lf ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
