/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec2(38u, 35u) ^ 0u) => uvec2(38u, 35u)
 * (uvec2(38u, 35u) ^ 6u) => uvec2(32u, 37u)
 * (uvec2(38u, 35u) ^ 12u) => uvec2(42u, 47u)
 * (uvec2(38u, 35u) ^ 32u) => uvec2(6u, 3u)
 * (uvec2(38u, 35u) ^ 74u) => uvec2(108u, 105u)
 * (uvec2(64u, 9u) ^ 0u) => uvec2(64u, 9u)
 * (uvec2(64u, 9u) ^ 6u) => uvec2(70u, 15u)
 * (uvec2(64u, 9u) ^ 12u) => uvec2(76u, 5u)
 * (uvec2(64u, 9u) ^ 32u) => uvec2(96u, 41u)
 * (uvec2(64u, 9u) ^ 74u) => uvec2(10u, 67u)
 */
#version 150

void main()
{
  float[all(equal((uvec2(38u, 35u) ^ 0u), uvec2(38u, 35u))) ? 1 : -1] array0;
  float[all(equal((uvec2(38u, 35u) ^ 6u), uvec2(32u, 37u))) ? 1 : -1] array1;
  float[all(equal((uvec2(38u, 35u) ^ 12u), uvec2(42u, 47u))) ? 1 : -1] array2;
  float[all(equal((uvec2(38u, 35u) ^ 32u), uvec2(6u, 3u))) ? 1 : -1] array3;
  float[all(equal((uvec2(38u, 35u) ^ 74u), uvec2(108u, 105u))) ? 1 : -1] array4;
  float[all(equal((uvec2(64u, 9u) ^ 0u), uvec2(64u, 9u))) ? 1 : -1] array5;
  float[all(equal((uvec2(64u, 9u) ^ 6u), uvec2(70u, 15u))) ? 1 : -1] array6;
  float[all(equal((uvec2(64u, 9u) ^ 12u), uvec2(76u, 5u))) ? 1 : -1] array7;
  float[all(equal((uvec2(64u, 9u) ^ 32u), uvec2(96u, 41u))) ? 1 : -1] array8;
  float[all(equal((uvec2(64u, 9u) ^ 74u), uvec2(10u, 67u))) ? 1 : -1] array9;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
