/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.stats;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.util.StringBufferExtensionsKt;
import org.jitsi.utils.OrderedJsonObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\fJ\u0016\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003J\u0016\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0000J\u001e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0016\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0017J\"\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\f0\u000bJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0002\u001a\u00020\u0003J\u0016\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\fJ\u000e\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0000J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\f2\u0006\u0010 \u001a\u00020\fH\u0002J\u0010\u0010!\u001a\u00020\u00032\b\b\u0002\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jitsi/nlj/stats/NodeStatsBlock;", "", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "stats", "", "compoundStats", "Lkotlin/Function1;", "", "addNumber", "", "value", "addString", "addBoolean", "", "addBlock", "otherBlock", "addJson", "json", "", "addCompoundValue", "compoundValue", "getValue", "getNumber", "getNumberOrDefault", "default", "aggregate", "promote", "n", "prettyPrint", "indentLevel", "", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "Companion", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nNodeStatsBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeStatsBlock.kt\norg/jitsi/nlj/stats/NodeStatsBlock\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,192:1\n1#2:193\n216#3,2:194\n216#3,2:196\n216#3,2:198\n216#3,2:200\n216#3,2:202\n216#3,2:204\n*S KotlinDebug\n*F\n+ 1 NodeStatsBlock.kt\norg/jitsi/nlj/stats/NodeStatsBlock\n*L\n100#1:194,2\n118#1:196,2\n137#1:198,2\n148#1:200,2\n160#1:202,2\n166#1:204,2\n*E\n"})
public final class NodeStatsBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final Map<String, Object> stats;
    @NotNull
    private final Map<String, Function1<NodeStatsBlock, Number>> compoundStats;
    @NotNull
    private static final String AGGREGATES = "_aggregates";

    public NodeStatsBlock(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.name = name;
        this.stats = new LinkedHashMap();
        this.compoundStats = new LinkedHashMap();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void addNumber(@NotNull String name, @NotNull Number value2) {
        block0: {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(value2, "value");
            Number number = this.promote(value2);
            if (number == null) break block0;
            Number it = number;
            boolean bl = false;
            this.stats.put(name, it);
        }
    }

    public final void addString(@NotNull String name, @NotNull String value2) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value2, "value");
        this.stats.put(name, value2);
    }

    public final void addBoolean(@NotNull String name, boolean value2) {
        Intrinsics.checkNotNullParameter(name, "name");
        Boolean bl = value2;
        this.stats.put(name, bl);
    }

    public final void addBlock(@NotNull NodeStatsBlock otherBlock) {
        Intrinsics.checkNotNullParameter(otherBlock, "otherBlock");
        this.stats.put(otherBlock.name, otherBlock);
    }

    public final void addJson(@NotNull String name, @NotNull Map<?, ?> json) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(json, "json");
        this.addBlock(Companion.fromJson(name, json));
    }

    public final void addCompoundValue(@NotNull String name, @NotNull Function1<? super NodeStatsBlock, ? extends Number> compoundValue) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(compoundValue, "compoundValue");
        this.compoundStats.put(name, compoundValue);
    }

    @Nullable
    public final Object getValue(@NotNull String name) {
        Object object;
        Intrinsics.checkNotNullParameter(name, "name");
        if (this.stats.containsKey(name)) {
            object = this.stats.get(name);
        } else if (this.compoundStats.containsKey(name)) {
            Function1<NodeStatsBlock, Number> function1 = this.compoundStats.get(name);
            object = function1 != null ? function1.invoke(this) : null;
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public final Number getNumber(@NotNull String name) {
        Number number;
        Intrinsics.checkNotNullParameter(name, "name");
        if (this.stats.get(name) instanceof Number) {
            Object object = this.stats.get(name);
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Number");
            number = (Number)object;
        } else if (this.compoundStats.containsKey(name)) {
            Function1<NodeStatsBlock, Number> function1 = this.compoundStats.get(name);
            number = function1 != null ? function1.invoke(this) : null;
        } else {
            number = null;
        }
        return number;
    }

    @NotNull
    public final Number getNumberOrDefault(@NotNull String name, @NotNull Number number) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(number, "default");
        Number number2 = this.getNumber(name);
        if (number2 == null) {
            number2 = number;
        }
        return number2;
    }

    public final void aggregate(@NotNull NodeStatsBlock otherBlock) {
        String name;
        Map.Entry<String, Object> entry;
        Map.Entry<String, Object> element$iv;
        Intrinsics.checkNotNullParameter(otherBlock, "otherBlock");
        Map<String, Object> $this$forEach$iv = otherBlock.stats;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            entry = element$iv = object.next();
            boolean bl = false;
            name = entry.getKey();
            Object value2 = entry.getValue();
            Object existingValue = this.stats.get(name);
            if (existingValue == null && (value2 instanceof Long || value2 instanceof Double)) {
                this.stats.put(name, value2);
                continue;
            }
            if (existingValue instanceof Long && value2 instanceof Long) {
                this.stats.put(name, ((Number)existingValue).longValue() + ((Number)value2).longValue());
                continue;
            }
            if (existingValue instanceof Double && value2 instanceof Double) {
                this.stats.put(name, ((Number)existingValue).doubleValue() + ((Number)value2).doubleValue());
                continue;
            }
            if (existingValue instanceof Long && value2 instanceof Double) {
                this.stats.put(name, ((Number)existingValue).doubleValue() + ((Number)value2).doubleValue());
                continue;
            }
            if (existingValue instanceof Double && value2 instanceof Long) {
                this.stats.put(name, ((Number)existingValue).doubleValue() + ((Number)value2).doubleValue());
                continue;
            }
            this.stats.put(name, value2);
        }
        $this$forEach$iv = otherBlock.compoundStats;
        $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            entry = element$iv = object.next();
            boolean bl = false;
            name = entry.getKey();
            Function1 function = (Function1)entry.getValue();
            this.addCompoundValue(name, function);
        }
        Map<String, Object> map = this.stats;
        String string = AGGREGATES;
        Object object2 = this.stats.getOrDefault(AGGREGATES, 0L);
        Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.Long");
        object = (Long)object2 + 1L;
        map.put(string, object);
    }

    private final Number promote(Number n) {
        Number number = n;
        return number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long ? (Number)n.longValue() : (Number)(number instanceof Float || number instanceof Double ? (Number)n.doubleValue() : null);
    }

    @NotNull
    public final String prettyPrint(int indentLevel) {
        String statName;
        Map.Entry<String, Object> entry;
        Map.Entry<String, Object> element$iv;
        StringBuffer $this$prettyPrint_u24lambda_u245 = new StringBuffer();
        boolean bl = false;
        StringBufferExtensionsKt.appendLnIndent($this$prettyPrint_u24lambda_u245, indentLevel, this.name);
        Map<String, Object> $this$forEach$iv = this.stats;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object;
            entry = element$iv = iterator2.next();
            boolean bl2 = false;
            statName = entry.getKey();
            Object statValue = entry.getValue();
            if (statValue instanceof NodeStatsBlock) {
                Appendable appendable = ((Appendable)$this$prettyPrint_u24lambda_u245).append(((NodeStatsBlock)statValue).prettyPrint(indentLevel + 2));
                Intrinsics.checkNotNullExpressionValue(appendable, "append(...)");
                Appendable appendable2 = appendable.append('\n');
                object = appendable2;
                Intrinsics.checkNotNullExpressionValue(appendable2, "append(...)");
                continue;
            }
            StringBufferExtensionsKt.appendLnIndent($this$prettyPrint_u24lambda_u245, indentLevel + 2, statName + ": " + statValue);
            object = Unit.INSTANCE;
        }
        $this$forEach$iv = this.compoundStats;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl3 = false;
            statName = entry.getKey();
            Function1 function = (Function1)entry.getValue();
            Number statValue = (Number)function.invoke(this);
            StringBufferExtensionsKt.appendLnIndent($this$prettyPrint_u24lambda_u245, indentLevel + 2, statName + ": " + statValue);
        }
        String string = $this$prettyPrint_u24lambda_u245.toString();
        Intrinsics.checkNotNullExpressionValue(string, "with(...)");
        return string;
    }

    public static /* synthetic */ String prettyPrint$default(NodeStatsBlock nodeStatsBlock, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return nodeStatsBlock.prettyPrint(n);
    }

    @NotNull
    public final OrderedJsonObject toJson() {
        String name;
        Map.Entry<String, Object> entry;
        Map.Entry<String, Object> element$iv;
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$toJson_u24lambda_u248 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        Map<String, Object> $this$forEach$iv = this.stats;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl2 = false;
            name = entry.getKey();
            Object value2 = entry.getValue();
            Object object = value2 instanceof NodeStatsBlock ? $this$toJson_u24lambda_u248.put(name, ((NodeStatsBlock)value2).toJson()) : $this$toJson_u24lambda_u248.put(name, value2);
        }
        $this$forEach$iv = this.compoundStats;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl3 = false;
            name = entry.getKey();
            Function1 function = (Function1)entry.getValue();
            $this$toJson_u24lambda_u248.put(name, function.invoke(this));
        }
        return orderedJsonObject;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u000e\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jitsi/nlj/stats/NodeStatsBlock$Companion;", "", "<init>", "()V", "AGGREGATES", "", "fromJson", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "name", "json", "", "jitsi-media-transform"})
    @SourceDebugExtension(value={"SMAP\nNodeStatsBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeStatsBlock.kt\norg/jitsi/nlj/stats/NodeStatsBlock$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n1863#2,2:193\n*S KotlinDebug\n*F\n+ 1 NodeStatsBlock.kt\norg/jitsi/nlj/stats/NodeStatsBlock$Companion\n*L\n181#1:193,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NodeStatsBlock fromJson(@NotNull String name, @NotNull Map<?, ?> json) {
            NodeStatsBlock nodeStatsBlock;
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(json, "json");
            NodeStatsBlock $this$fromJson_u24lambda_u241 = nodeStatsBlock = new NodeStatsBlock(name);
            boolean bl = false;
            Iterable $this$forEach$iv = json.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl2 = false;
                Object key = entry.getKey();
                Object value2 = entry.getValue();
                Object v = value2;
                if (v instanceof Map) {
                    $this$fromJson_u24lambda_u241.addBlock(Companion.fromJson(String.valueOf(key), (Map)value2));
                    continue;
                }
                if (v instanceof Number) {
                    $this$fromJson_u24lambda_u241.addNumber(String.valueOf(key), (Number)value2);
                    continue;
                }
                if (v instanceof Boolean) {
                    $this$fromJson_u24lambda_u241.addBoolean(String.valueOf(key), (Boolean)value2);
                    continue;
                }
                $this$fromJson_u24lambda_u241.addString(String.valueOf(key), String.valueOf(value2));
            }
            return nodeStatsBlock;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

