/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.injector;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.injector.Injector;
import org.pentaho.di.trans.steps.injector.InjectorData;
import org.pentaho.di.trans.steps.injector.Messages;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectorMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String[] name;
    private int[] type;
    private int[] length;
    private int[] precision;

    public int[] getLength() {
        return this.length;
    }

    public void setLength(int[] length) {
        this.length = length;
    }

    public String[] getName() {
        return this.name;
    }

    public void setName(String[] name) {
        this.name = name;
    }

    public int[] getPrecision() {
        return this.precision;
    }

    public void setPrecision(int[] precision) {
        this.precision = precision;
    }

    public int[] getType() {
        return this.type;
    }

    public void setType(int[] type) {
        this.type = type;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    public void allocate(int nrFields) {
        this.name = new String[nrFields];
        this.type = new int[nrFields];
        this.length = new int[nrFields];
        this.precision = new int[nrFields];
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("    <fields>");
        for (int i = 0; i < this.name.length; ++i) {
            retval.append("      <field>");
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.name[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)ValueMeta.getTypeDesc((int)this.type[i])));
            retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)this.length[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)this.precision[i]));
            retval.append("      </field>");
        }
        retval.append("    </fields>");
        return retval.toString();
    }

    private void readData(Node stepnode) {
        Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
        int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            Node line = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
            this.name[i] = XMLHandler.getTagValue((Node)line, (String)"name");
            this.type[i] = ValueMeta.getType((String)XMLHandler.getTagValue((Node)line, (String)"type"));
            this.length[i] = Const.toInt((String)XMLHandler.getTagValue((Node)line, (String)"length"), (int)-2);
            this.precision[i] = Const.toInt((String)XMLHandler.getTagValue((Node)line, (String)"precision"), (int)-2);
        }
    }

    @Override
    public void setDefault() {
        this.allocate(0);
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.name[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.type[i] = ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "field_type"));
                this.length[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_length");
                this.precision[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_precision");
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("InjectorMeta.Exception.ErrorReadingStepInfoFromRepository"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            for (int i = 0; i < this.name.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", this.name[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_type", ValueMeta.getTypeDesc((int)this.type[i]));
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_length", this.length[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_precision", this.precision[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("InjectorMeta.Exception.UnableToSaveStepInfoToRepository") + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        for (int i = 0; i < this.name.length; ++i) {
            ValueMeta v = new ValueMeta(this.name[i], this.type[i], this.length[i], this.precision[i]);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(4, Messages.getString("InjectorMeta.CheckResult.StepExpectingNoReadingInfoFromOtherSteps"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            CheckResult cr = new CheckResult(1, Messages.getString("InjectorMeta.CheckResult.NoInputReceivedError"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new Injector(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new InjectorData();
    }
}

