/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geocoder;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.ws.rs.client.Client;
import org.traccar.geocoder.Address;
import org.traccar.geocoder.AddressFormat;
import org.traccar.geocoder.JsonGeocoder;

public class GeoapifyGeocoder
extends JsonGeocoder {
    private static String formatUrl(String key, String language) {
        Object url = "https://api.geoapify.com/v1/geocode/reverse?format=json&lat=%f&lon=%f";
        if (key != null) {
            url = (String)url + "&apiKey=" + key;
        }
        if (language != null) {
            url = (String)url + "&lang=" + language;
        }
        return url;
    }

    public GeoapifyGeocoder(Client client, String key, String language, int cacheSize, AddressFormat addressFormat) {
        super(client, GeoapifyGeocoder.formatUrl(key, language), cacheSize, addressFormat);
    }

    @Override
    public Address parseAddress(JsonObject json) {
        JsonArray results = json.getJsonArray("results");
        if (results.size() > 0) {
            JsonObject result = results.getJsonObject(0);
            Address address = new Address();
            if (json.containsKey((Object)"formatted")) {
                address.setFormattedAddress(json.getString("formatted"));
            }
            if (result.containsKey((Object)"housenumber")) {
                address.setHouse(result.getString("housenumber"));
            }
            if (result.containsKey((Object)"street")) {
                address.setStreet(result.getString("street"));
            }
            if (result.containsKey((Object)"suburb")) {
                address.setSuburb(result.getString("suburb"));
            }
            if (result.containsKey((Object)"city")) {
                address.setSettlement(result.getString("city"));
            }
            if (result.containsKey((Object)"district")) {
                address.setDistrict(result.getString("district"));
            }
            if (result.containsKey((Object)"state")) {
                address.setState(result.getString("state"));
            }
            if (result.containsKey((Object)"country_code")) {
                address.setCountry(result.getString("country_code").toUpperCase());
            }
            if (result.containsKey((Object)"postcode")) {
                address.setPostcode(result.getString("postcode"));
            }
            return address;
        }
        return null;
    }
}

