/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.filter;

import ca.odell.glazedlists.impl.GlazedListsImpl;
import ca.odell.glazedlists.matchers.SearchEngineTextMatcherEditor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SearchTerm<E>
implements Serializable {
    private final String text;
    private final boolean negated;
    private final boolean required;
    private final SearchEngineTextMatcherEditor.Field<E> field;
    private final List<String> fieldFilterStrings = new ArrayList<String>();

    public SearchTerm(String text) {
        this(text, false, false, null);
    }

    public SearchTerm(String text, boolean negated, boolean required, SearchEngineTextMatcherEditor.Field<E> field) {
        if (text == null) {
            throw new IllegalArgumentException("text may not be null");
        }
        this.text = text;
        this.negated = negated;
        this.required = required;
        this.field = field;
    }

    public String getText() {
        return this.text;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public boolean isRequired() {
        return this.required;
    }

    public SearchEngineTextMatcherEditor.Field<E> getField() {
        return this.field;
    }

    List<String> getFieldFilterStrings() {
        return this.fieldFilterStrings;
    }

    public SearchTerm<E> newSearchTerm(String text) {
        return new SearchTerm<E>(text, this.isNegated(), this.isRequired(), this.getField());
    }

    boolean isConstrainment(SearchTerm term) {
        if (this.isNegated() != term.isNegated()) {
            return false;
        }
        if (!GlazedListsImpl.equal(this.getField(), term.getField())) {
            return false;
        }
        if (this.getText().equals(term.getText())) {
            return false;
        }
        return this.isNegated() ? term.getText().indexOf(this.getText()) != -1 : this.getText().indexOf(term.getText()) != -1;
    }

    boolean isRelaxation(SearchTerm term) {
        return term.isConstrainment(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchTerm that = (SearchTerm)o;
        if (this.negated != that.negated) {
            return false;
        }
        if (this.required != that.required) {
            return false;
        }
        if (this.field != null ? !this.field.equals(that.field) : that.field != null) {
            return false;
        }
        return this.text.equals(that.text);
    }

    public int hashCode() {
        int result = this.text.hashCode();
        result = 31 * result + (this.negated ? 1 : 0);
        result = 31 * result + (this.required ? 1 : 0);
        result = 31 * result + (this.field != null ? this.field.hashCode() : 0);
        return result;
    }
}

