/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.util.resource.Resource;
import org.openhab.core.OpenHAB;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContext;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletName;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={Servlet.class}, name="org.openhab.ui")
@NonNullByDefault
@HttpWhiteboardServletName(value="/")
@HttpWhiteboardServletPattern(value={"/*"})
@HttpWhiteboardContext(name="=org.openhab.ui.context", path="=/")
public class UIServlet
extends DefaultServlet {
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(UIServlet.class);
    private static final String APP_BASE = "app";
    public static final String SERVLET_PATH = "/";
    private static final String STATIC_PATH = "/static";
    private static final String STATIC_BASE = OpenHAB.getConfigFolder() + "/html";
    private static final String[] COMPRESS_EXT = new String[]{"gz", "br"};
    private final HttpContext defaultHttpContext;
    private final long bundleModifiedTime;
    private @Nullable ContextHandler contextHandler;

    @Activate
    public UIServlet(@Reference WebContainer webContainer) {
        this.defaultHttpContext = webContainer.createDefaultHttpContext();
        this.logger.debug("Starting up {} at {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)SERVLET_PATH);
        this.bundleModifiedTime = System.currentTimeMillis() / 1000L * 1000L;
    }

    public void init() throws UnavailableException {
        this.contextHandler = ContextHandler.getCurrentContext().getContextHandler();
        super.init();
    }

    public @Nullable Resource getResource(@NonNullByDefault(value={}) String name) {
        this.logger.debug("getResource: {}", (Object)name);
        ContextHandler contextHandler = this.contextHandler;
        if (contextHandler == null) {
            return null;
        }
        if (name.startsWith(STATIC_PATH) && !name.endsWith(SERVLET_PATH)) {
            URL url = null;
            try {
                url = new File(STATIC_BASE + name.substring(STATIC_PATH.length())).toURI().toURL();
            }
            catch (MalformedURLException e) {
                this.logger.error("Error while serving static content: {}", (Object)e.getMessage());
                url = this.defaultHttpContext.getResource(APP_BASE + name);
            }
            try {
                this.logger.debug("getResource static file returning {}", (Object)url);
                return contextHandler.newResource(url);
            }
            catch (IOException e) {
                this.logger.error("Error while serving content: {}", (Object)e.getMessage());
                return null;
            }
        }
        URL url = this.defaultHttpContext.getResource(APP_BASE + name);
        if (url == null) {
            if (Arrays.stream(COMPRESS_EXT).noneMatch(name::endsWith)) {
                return null;
            }
        }
        try {
            this.logger.debug("getResource bundle file returning {}", (Object)url);
            return url == null ? null : new ResourceWrapper(contextHandler.newResource(url));
        }
        catch (IOException e) {
            this.logger.error("Error while serving content: {}", (Object)e.getMessage());
            return null;
        }
    }

    protected void doGet(@Nullable HttpServletRequest request, @Nullable HttpServletResponse response) throws ServletException, IOException {
        if (request == null || response == null) {
            return;
        }
        if (!this.defaultHttpContext.handleSecurity(request, response)) {
            response.sendError(403);
            return;
        }
        super.doGet(request, response);
    }

    public @Nullable String getWelcomeFile(@Nullable String pathInContext) {
        this.logger.debug("getWelcomeFile {}", (Object)pathInContext);
        if (pathInContext != null && pathInContext.startsWith(STATIC_PATH)) {
            return null;
        }
        return "/index.html";
    }

    class ResourceWrapper
    extends Resource {
        private final Resource baseResource;

        public ResourceWrapper(Resource baseResource) {
            this.baseResource = baseResource;
        }

        public long lastModified() {
            return UIServlet.this.bundleModifiedTime;
        }

        public boolean isContainedIn(@Nullable Resource r) throws MalformedURLException {
            return this.baseResource.isContainedIn(r);
        }

        public void close() {
            this.baseResource.close();
        }

        public boolean exists() {
            return this.baseResource.exists();
        }

        public boolean isDirectory() {
            return this.baseResource.isDirectory();
        }

        public long length() {
            return this.baseResource.length();
        }

        public URL getURL() {
            return this.baseResource.getURL();
        }

        public File getFile() throws IOException {
            return this.baseResource.getFile();
        }

        public String getName() {
            return this.baseResource.getName();
        }

        public InputStream getInputStream() throws IOException {
            return this.baseResource.getInputStream();
        }

        public ReadableByteChannel getReadableByteChannel() throws IOException {
            return this.baseResource.getReadableByteChannel();
        }

        public boolean delete() throws SecurityException {
            return this.baseResource.delete();
        }

        public boolean renameTo(@Nullable Resource dest) throws SecurityException {
            return this.baseResource.renameTo(dest);
        }

        public String[] list() {
            return this.baseResource.list();
        }

        public Resource addPath(@Nullable String path) throws IOException {
            return this.baseResource.addPath(path);
        }

        public String toString() {
            return this.getURL().toString();
        }
    }
}

