/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core;

import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;

public enum HolidayCalendar {
    ALBANIA("AL"),
    ANDORRA("AD"),
    ARGENTINA("AR"),
    AUSTRALIA("AU"),
    AUSTRIA("AT"),
    BAHAMAS("BS"),
    BELARUS("BY"),
    BELGIUM("BE"),
    BERMUDA("BM"),
    BOLIVIA("BO"),
    BOSNIA_HERZIGOWINA("BA"),
    BRAZIL("BR"),
    BRITISH_VIRGIN_ISLANDS("VG"),
    BULGARIA("BG"),
    CANADA(Locale.CANADA.getCountry()),
    CAYMAN_ISLANDS("KY"),
    CHILE("CL"),
    COLOMBIA("CO"),
    COSTA_RICA("CR"),
    CROATIA("HR"),
    CUBA("CU"),
    CZECH_REPUBLIC("CZ"),
    CYPRUS("CY"),
    DENMARK("DK"),
    DOW_JONES_STOXX("DJ_STOXX"),
    ECUADOR("EC"),
    EGYPT("EG"),
    ESTONIA("EE"),
    ETHIOPIA("ET"),
    FINLAND("FI"),
    FRANCE(Locale.FRANCE.getCountry()),
    GEORGIA("GE"),
    GERMANY(Locale.GERMANY.getCountry()),
    GUERNSEY("GG"),
    GREECE("GR"),
    HONG_KONG("HK"),
    HUNGARY("HU"),
    ICELAND("IS"),
    INDIA("IN"),
    IRELAND("IE"),
    ISLE_OF_MAN("IM"),
    ITALY(Locale.ITALY.getCountry()),
    JAPAN("JP"),
    JERSEY("JE"),
    KAZAKHSTAN("KZ"),
    KOSOVO("XK"),
    LATVIA("LV"),
    LIECHTENSTEIN("LI"),
    LITHUANIA("LT"),
    LONDON_METAL_EXCHANGE("LME"),
    LUXEMBOURG("LU"),
    MACEDONIA("MK"),
    MALTA("MT"),
    MONACO("MC"),
    MOROCCO("MA"),
    MAURITIUS("MU"),
    MEXICO("MX"),
    MOLDOVA("MD"),
    MONTENEGRO("ME"),
    NETHERLANDS("NL"),
    NEW_ZEALAND("NZ"),
    NICARAGUA("NI"),
    NIGERIA("NG"),
    NORWAY("NO"),
    NYSE("NYSE"),
    NYSE_EURONEXT("NYSE_EURONEXT"),
    PANAMA("PA"),
    PARAGUAY("PY"),
    PERU("PE"),
    POLAND("PL"),
    PORTUGAL("PT"),
    ROMANIA("RO"),
    RUSSIA("RU"),
    SAN_MARINO("SM"),
    SAUDI_ARABIA("SA"),
    SERBIA("RS"),
    SINGAPORE("SG"),
    SLOWAKIA("SK"),
    SLOWENIA("SI"),
    SOUTH_AFRICA("ZA"),
    SPAIN("ES"),
    SWEDEN("SE"),
    SWITZERLAND("CH"),
    TARGET("TARGET"),
    TURKEY("TR"),
    UKRAINE("UA"),
    UNITED_ARAB_EMIRATES("AE"),
    UNITED_KINGDOM(Locale.UK.getCountry()),
    UNITED_STATES(Locale.US.getCountry()),
    URUGUAY("UY"),
    VENEZUELA("VE");

    private final String id;

    private HolidayCalendar(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public static Set<String> getSupportedCalendarCodes() {
        return Arrays.stream(HolidayCalendar.values()).map(HolidayCalendar::getId).collect(Collectors.toUnmodifiableSet());
    }
}

