/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.compiler.varlen;

import com.igormaznitsa.jbbp.JBBPNamedNumericFieldMap;
import com.igormaznitsa.jbbp.compiler.JBBPCompiledBlock;
import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.compiler.conversion.ExpressionEvaluatorVisitor;
import com.igormaznitsa.jbbp.compiler.varlen.JBBPIntegerValueEvaluator;
import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.model.JBBPNumericField;

public final class JBBPOnlyFieldEvaluator
implements JBBPIntegerValueEvaluator {
    private static final long serialVersionUID = -1031131501937541693L;
    private final int namedFieldIndex;
    private final String externalFieldName;

    public JBBPOnlyFieldEvaluator(String externalFieldName, int namedFieldIndex) {
        this.externalFieldName = externalFieldName;
        this.namedFieldIndex = namedFieldIndex;
    }

    @Override
    public int eval(JBBPBitInputStream inStream, int currentCompiledBlockOffset, JBBPCompiledBlock block, JBBPNamedNumericFieldMap fieldMap) {
        int result;
        if (this.externalFieldName == null) {
            JBBPNamedFieldInfo namedField = block.getNamedFields()[this.namedFieldIndex];
            JBBPNumericField numericField = fieldMap.get(namedField);
            if (numericField == null) {
                throw new ArithmeticException("Can't find field '" + namedField.getFieldName() + "' among numeric fields");
            }
            result = numericField.getAsInt();
        } else {
            result = this.externalFieldName.equals("$") ? (int)inStream.getCounter() : fieldMap.getExternalFieldValue(this.externalFieldName, block, this);
        }
        return result;
    }

    public String toString() {
        return this.externalFieldName == null ? "NamedFieldIndex=" + this.namedFieldIndex : this.externalFieldName;
    }

    @Override
    public void visitItems(JBBPCompiledBlock block, int currentCompiledBlockOffset, ExpressionEvaluatorVisitor visitor) {
        visitor.visitStart();
        if (this.externalFieldName == null) {
            visitor.visitField(block.getNamedFields()[this.namedFieldIndex], null);
        } else if (this.externalFieldName.equals("$")) {
            visitor.visitSpecial(ExpressionEvaluatorVisitor.Special.STREAM_COUNTER);
        } else {
            visitor.visitField(null, this.externalFieldName);
        }
        visitor.visitEnd();
    }
}

