/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.preferences.sources.ValidatorPrefHelper;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.util.AggregatePrimitivesVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.gui.layer.ValidatorLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

public class ValidateAction
extends JosmAction {
    private transient Collection<OsmPrimitive> lastSelection;

    public ValidateAction() {
        super(I18n.tr("Validation", new Object[0]), "dialogs/validator", I18n.tr("Performs the data validation", new Object[0]), Shortcut.registerShortcut("tools:validate", I18n.tr("Tool: {0}", I18n.tr("Validation", new Object[0])), 86, 5005), true);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        this.doValidate(true);
    }

    public void doValidate(boolean getSelectedItems) {
        Collection<OsmPrimitive> selection;
        MapFrame map = MainApplication.getMap();
        if (map == null || !map.isVisible()) {
            return;
        }
        OsmValidator.initializeTests();
        OsmValidator.initializeErrorLayer();
        Collection<Test> tests = OsmValidator.getEnabledTests(false);
        if (tests.isEmpty()) {
            return;
        }
        if (getSelectedItems) {
            selection = this.getLayerManager().getActiveDataSet().getAllSelected();
            if (selection.isEmpty()) {
                selection = this.getLayerManager().getActiveDataSet().allNonDeletedPrimitives();
                this.lastSelection = null;
            } else {
                AggregatePrimitivesVisitor v = new AggregatePrimitivesVisitor();
                selection = v.visit(selection);
                this.lastSelection = selection;
            }
        } else {
            selection = Optional.ofNullable(this.lastSelection).orElseGet(() -> this.getLayerManager().getActiveDataSet().allNonDeletedPrimitives());
        }
        MainApplication.worker.submit(new ValidationTask(tests, selection, this.lastSelection));
    }

    @Override
    public void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getActiveDataSet() != null);
    }

    @Override
    public void destroy() {
        this.lastSelection = null;
    }

    static class ValidationTask
    extends PleaseWaitRunnable {
        private Collection<Test> tests;
        private final Collection<OsmPrimitive> validatedPrimitives;
        private final Collection<OsmPrimitive> formerValidatedPrimitives;
        private boolean canceled;
        private List<TestError> errors;

        ValidationTask(Collection<Test> tests, Collection<OsmPrimitive> validatedPrimitives, Collection<OsmPrimitive> formerValidatedPrimitives) {
            super(I18n.tr("Validating", new Object[0]), false);
            this.validatedPrimitives = validatedPrimitives;
            this.formerValidatedPrimitives = formerValidatedPrimitives;
            this.tests = tests;
        }

        @Override
        protected void cancel() {
            this.canceled = true;
        }

        @Override
        protected void finish() {
            if (this.canceled) {
                return;
            }
            GuiHelper.runInEDT(() -> {
                MapFrame map = MainApplication.getMap();
                map.validatorDialog.unfurlDialog();
                map.validatorDialog.tree.setErrors(this.errors);
                MainApplication.getLayerManager().getLayersOfType(ValidatorLayer.class).forEach(AbstractMapViewPaintable::invalidate);
            });
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            if (this.tests == null || this.tests.isEmpty()) {
                return;
            }
            this.errors = new ArrayList<TestError>(200);
            this.getProgressMonitor().setTicksCount(this.tests.size() * this.validatedPrimitives.size());
            int testCounter = 0;
            for (Test test : this.tests) {
                if (this.canceled) {
                    return;
                }
                this.getProgressMonitor().setCustomText(I18n.tr("Test {0}/{1}: Starting {2}", ++testCounter, this.tests.size(), test.getName()));
                test.setPartialSelection(this.formerValidatedPrimitives != null);
                test.startTest(this.getProgressMonitor().createSubTaskMonitor(this.validatedPrimitives.size(), false));
                test.visit(this.validatedPrimitives);
                test.endTest();
                this.errors.addAll(test.getErrors());
                test.clear();
            }
            this.tests = null;
            if (ValidatorPrefHelper.PREF_USE_IGNORE.get().booleanValue()) {
                this.getProgressMonitor().setCustomText("");
                this.getProgressMonitor().subTask(I18n.tr("Updating ignored errors ...", new Object[0]));
                for (TestError error : this.errors) {
                    if (this.canceled) {
                        return;
                    }
                    ArrayList<String> s = new ArrayList<String>();
                    s.add(error.getIgnoreState());
                    s.add(error.getIgnoreGroup());
                    s.add(error.getIgnoreSubGroup());
                    for (String state : s) {
                        if (state == null || !OsmValidator.hasIgnoredError(state)) continue;
                        error.setIgnored(true);
                    }
                }
            }
        }
    }
}

