# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("rasdlg.dll")
prototypes = \
    {
        #
        'RasPhonebookDlgA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "xDlg": SimTypeInt(signed=True, label="Int32"), "yDlg": SimTypeInt(signed=True, label="Int32"), "dwCallbackId": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "pCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "dwError": SimTypeInt(signed=False, label="UInt32"), "reserved": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "reserved2": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="RASPBDLGA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszPhonebook", "lpszEntry", "lpInfo"]),
        #
        'RasPhonebookDlgW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "xDlg": SimTypeInt(signed=True, label="Int32"), "yDlg": SimTypeInt(signed=True, label="Int32"), "dwCallbackId": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "pCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "dwError": SimTypeInt(signed=False, label="UInt32"), "reserved": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "reserved2": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="RASPBDLGW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszPhonebook", "lpszEntry", "lpInfo"]),
        #
        'RasEntryDlgA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "xDlg": SimTypeInt(signed=True, label="Int32"), "yDlg": SimTypeInt(signed=True, label="Int32"), "szEntry": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257), "dwError": SimTypeInt(signed=False, label="UInt32"), "reserved": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "reserved2": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="RASENTRYDLGA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszPhonebook", "lpszEntry", "lpInfo"]),
        #
        'RasEntryDlgW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "xDlg": SimTypeInt(signed=True, label="Int32"), "yDlg": SimTypeInt(signed=True, label="Int32"), "szEntry": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "dwError": SimTypeInt(signed=False, label="UInt32"), "reserved": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "reserved2": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="RASENTRYDLGW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszPhonebook", "lpszEntry", "lpInfo"]),
        #
        'RasDialDlgA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "xDlg": SimTypeInt(signed=True, label="Int32"), "yDlg": SimTypeInt(signed=True, label="Int32"), "dwSubEntry": SimTypeInt(signed=False, label="UInt32"), "dwError": SimTypeInt(signed=False, label="UInt32"), "reserved": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "reserved2": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="RASDIALDLG", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszPhonebook", "lpszEntry", "lpszPhoneNumber", "lpInfo"]),
        #
        'RasDialDlgW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "xDlg": SimTypeInt(signed=True, label="Int32"), "yDlg": SimTypeInt(signed=True, label="Int32"), "dwSubEntry": SimTypeInt(signed=False, label="UInt32"), "dwError": SimTypeInt(signed=False, label="UInt32"), "reserved": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "reserved2": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="RASDIALDLG", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszPhonebook", "lpszEntry", "lpszPhoneNumber", "lpInfo"]),
    }

lib.set_prototypes(prototypes)
