/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.binary.asm;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.access.binary.asm.AbstractBinarySignature;
import org.eclipse.xtext.common.types.access.binary.asm.BinaryGenericTypeSignature;
import org.eclipse.xtext.common.types.access.binary.asm.BinaryTypeParameter;
import org.eclipse.xtext.common.types.access.binary.asm.JvmAnnotationReferenceBuilder;
import org.eclipse.xtext.common.types.access.binary.asm.Proxies;
import org.eclipse.xtext.common.types.impl.JvmTypeConstraintImplCustom;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Opcodes;

public abstract class JvmAnnotationTargetBuilder
implements Opcodes {
    protected final Proxies proxies;

    protected JvmAnnotationTargetBuilder(Proxies proxies) {
        this.proxies = proxies;
    }

    protected abstract JvmAnnotationTarget getInstance();

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return new JvmAnnotationReferenceBuilder((InternalEList<JvmAnnotationReference>)((InternalEList)this.getInstance().getAnnotations()), desc, this.proxies);
    }

    public void visitEnd() {
    }

    protected void setVisibility(int accessFlags, JvmMember result) {
        switch (accessFlags & 7) {
            case 2: {
                result.setVisibility(JvmVisibility.PRIVATE);
                return;
            }
            case 4: {
                result.setVisibility(JvmVisibility.PROTECTED);
                return;
            }
            case 1: {
                result.setVisibility(JvmVisibility.PUBLIC);
                return;
            }
        }
        result.setVisibility(JvmVisibility.DEFAULT);
    }

    protected boolean isClinit(String selector) {
        return selector.charAt(0) == '<' && selector.length() == 8;
    }

    protected boolean isConstructor(String selector) {
        return selector.charAt(0) == '<' && selector.length() == 6;
    }

    protected Map<String, JvmTypeParameter> createTypeParameters(AbstractBinarySignature signature, JvmTypeParameterDeclarator container, Map<String, JvmTypeParameter> knownTypeParameters) {
        List<BinaryTypeParameter> typeParameters = signature.getTypeParameters();
        if (typeParameters.size() != 0) {
            HashMap result = Maps.newHashMapWithExpectedSize((int)((knownTypeParameters != null ? knownTypeParameters.size() : 0) + typeParameters.size()));
            if (knownTypeParameters != null) {
                result.putAll(knownTypeParameters);
            }
            InternalEList jvmTypeParameters = (InternalEList)container.getTypeParameters();
            int i = 0;
            while (i < typeParameters.size()) {
                JvmTypeParameter typeParameter = TypesFactory.eINSTANCE.createJvmTypeParameter();
                String name = typeParameters.get(i).getName();
                typeParameter.setName(name);
                jvmTypeParameters.addUnique((Object)typeParameter);
                result.put(name, typeParameter);
                ++i;
            }
            i = 0;
            while (i < typeParameters.size()) {
                List<BinaryGenericTypeSignature> bounds = typeParameters.get(i).getBounds();
                JvmTypeParameter typeParameter = (JvmTypeParameter)jvmTypeParameters.get(i);
                InternalEList constraints = (InternalEList)typeParameter.getConstraints();
                int j = 0;
                while (j < bounds.size()) {
                    JvmUpperBound upperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
                    ((JvmTypeConstraintImplCustom)((Object)upperBound)).internalSetTypeReference(this.proxies.createTypeReference(bounds.get(j), result));
                    constraints.addUnique((Object)upperBound);
                    ++j;
                }
                ++i;
            }
            return result;
        }
        return knownTypeParameters;
    }
}

