/**
Provides access to the properties of <audio> elements, as well as methods to manipulate them. It derives from the HTMLMediaElement interface.

@returns {HTMLAudioElement}
*/
HTMLAudioElement = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**

Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | AddEventListenerOptions)} [options] boolean | AddEventListenerOptions
@returns {undefined}
**/
HTMLAudioElement.prototype.addEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**

Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | EventListenerOptions)} [options] boolean | EventListenerOptions
@returns {undefined}
**/
HTMLAudioElement.prototype.removeEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLAudioElement.prototype.autoplay = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {TimeRanges}
**/
HTMLAudioElement.prototype.buffered = new TimeRanges();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLAudioElement.prototype.controls = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.crossOrigin = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.currentSrc = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.currentTime = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLAudioElement.prototype.defaultMuted = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.defaultPlaybackRate = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLAudioElement.prototype.disableRemotePlayback = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.duration = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLAudioElement.prototype.ended = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(MediaError | null)} MediaError | null
**/
HTMLAudioElement.prototype.error = new MediaError();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLAudioElement.prototype.loop = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(MediaKeys | null)} MediaKeys | null
**/
HTMLAudioElement.prototype.mediaKeys = new MediaKeys();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLAudioElement.prototype.muted = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.networkState = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: HTMLMediaElement, ev: MediaEncryptedEvent) => any) | null
**/
HTMLAudioElement.prototype.onencrypted = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: HTMLMediaElement, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onwaitingforkey = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLAudioElement.prototype.paused = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.playbackRate = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {TimeRanges}
**/
HTMLAudioElement.prototype.played = new TimeRanges();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {("none" | "metadata" | "auto" | "")} "none" | "metadata" | "auto" | ""
**/
HTMLAudioElement.prototype.preload = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.readyState = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {RemotePlayback}
**/
HTMLAudioElement.prototype.remote = new RemotePlayback();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {TimeRanges}
**/
HTMLAudioElement.prototype.seekable = new TimeRanges();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLAudioElement.prototype.seeking = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.src = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(MediaStream | MediaSource | Blob | null)} MediaProvider | null
**/
HTMLAudioElement.prototype.srcObject = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {TextTrackList}
**/
HTMLAudioElement.prototype.textTracks = new TextTrackList();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.volume = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {("captions" | "chapters" | "descriptions" | "metadata" | "subtitles")} kind TextTrackKind
@param {String} [label]
@param {String} [language]
@returns {TextTrack}
**/
HTMLAudioElement.prototype.addTextTrack = function(kind) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a string that specifies whether the client can play a given media resource type.

@param {String} type
@returns {("" | "maybe" | "probably")} CanPlayTypeResult
**/
HTMLAudioElement.prototype.canPlayType = function(type) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} time
@returns {undefined}
**/
HTMLAudioElement.prototype.fastSeek = function(time) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Resets the audio or video object and loads a new media resource.

@returns {undefined}
**/
HTMLAudioElement.prototype.load = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Pauses the current playback and sets paused to TRUE. This can be used to test whether the media is playing or paused. You can also use the pause or play events to tell whether the media is playing or not.

@returns {undefined}
**/
HTMLAudioElement.prototype.pause = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Loads and starts playback of a media resource.

@returns {Promise}
**/
HTMLAudioElement.prototype.play = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Available only in secure contexts.

@param {(MediaKeys | null)} mediaKeys MediaKeys | null
@returns {Promise}
**/
HTMLAudioElement.prototype.setMediaKeys = function(mediaKeys) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.HAVE_CURRENT_DATA = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.HAVE_ENOUGH_DATA = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.HAVE_FUTURE_DATA = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.HAVE_METADATA = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.HAVE_NOTHING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.NETWORK_EMPTY = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.NETWORK_IDLE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.NETWORK_LOADING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.NETWORK_NO_SOURCE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**

Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | AddEventListenerOptions)} [options] boolean | AddEventListenerOptions
@returns {undefined}
**/
HTMLAudioElement.prototype.addEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**

Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | EventListenerOptions)} [options] boolean | EventListenerOptions
@returns {undefined}
**/
HTMLAudioElement.prototype.removeEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.accessKey = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.accessKeyLabel = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.autocapitalize = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.dir = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLAudioElement.prototype.draggable = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLAudioElement.prototype.hidden = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.innerText = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.lang = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.offsetHeight = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.offsetLeft = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Element | null)} Element | null
**/
HTMLAudioElement.prototype.offsetParent = new Element();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.offsetTop = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.offsetWidth = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.outerText = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLAudioElement.prototype.spellcheck = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.title = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLAudioElement.prototype.translate = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {ElementInternals}
**/
HTMLAudioElement.prototype.attachInternals = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {undefined}
**/
HTMLAudioElement.prototype.click = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**

Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | AddEventListenerOptions)} [options] boolean | AddEventListenerOptions
@returns {undefined}
**/
HTMLAudioElement.prototype.addEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**

Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | EventListenerOptions)} [options] boolean | EventListenerOptions
@returns {undefined}
**/
HTMLAudioElement.prototype.removeEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {NamedNodeMap}
**/
HTMLAudioElement.prototype.attributes = new NamedNodeMap();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {DOMTokenList}
**/
HTMLAudioElement.prototype.classList = new DOMTokenList();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.className = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.clientHeight = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.clientLeft = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.clientTop = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.clientWidth = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.id = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.localName = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.namespaceURI = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: Element, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onfullscreenchange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: Element, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onfullscreenerror = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.outerHTML = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Document}
**/
HTMLAudioElement.prototype.ownerDocument = new Document();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {DOMTokenList}
**/
HTMLAudioElement.prototype.part = new DOMTokenList();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.prefix = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.scrollHeight = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.scrollLeft = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.scrollTop = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.scrollWidth = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ShadowRoot | null)} ShadowRoot | null
**/
HTMLAudioElement.prototype.shadowRoot = new ShadowRoot();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.slot = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.tagName = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Creates a shadow root for element and returns it.

@param {ShadowRootInit} init ShadowRootInit
@returns {ShadowRoot}
**/
HTMLAudioElement.prototype.attachShadow = function(init) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns the first (starting at element) inclusive ancestor that matches selectors, and null otherwise.

@param {String} selectors
@returns {(Object | null)} E | null
**/
HTMLAudioElement.prototype.closest = function(selectors) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns element's first attribute whose qualified name is qualifiedName, and null if there is no such attribute otherwise.

@param {String} qualifiedName
@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.getAttribute = function(qualifiedName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns element's attribute whose namespace is namespace and local name is localName, and null if there is no such attribute otherwise.

@param {(String | null)} namespace string | null
@param {String} localName
@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.getAttributeNS = function(namespace, localName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns the qualified names of all element's attributes. Can contain duplicates.

@returns {String}
**/
HTMLAudioElement.prototype.getAttributeNames = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} qualifiedName
@returns {(Attr | null)} Attr | null
**/
HTMLAudioElement.prototype.getAttributeNode = function(qualifiedName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@param {String} localName
@returns {(Attr | null)} Attr | null
**/
HTMLAudioElement.prototype.getAttributeNodeNS = function(namespace, localName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {DOMRect}
**/
HTMLAudioElement.prototype.getBoundingClientRect = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {DOMRectList}
**/
HTMLAudioElement.prototype.getClientRects = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a HTMLCollection of the elements in the object on which the method was invoked (a document or an element) that have all the classes given by classNames. The classNames argument is interpreted as a space-separated list of classes.

@param {String} classNames
@returns {HTMLCollectionOf}
**/
HTMLAudioElement.prototype.getElementsByClassName = function(classNames) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} qualifiedName
@returns {HTMLCollectionOf}
**/
HTMLAudioElement.prototype.getElementsByTagName = function(qualifiedName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@param {String} localName
@returns {HTMLCollectionOf}
**/
HTMLAudioElement.prototype.getElementsByTagNameNS = function(namespace, localName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns true if element has an attribute whose qualified name is qualifiedName, and false otherwise.

@param {String} qualifiedName
@returns {Boolean}
**/
HTMLAudioElement.prototype.hasAttribute = function(qualifiedName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns true if element has an attribute whose namespace is namespace and local name is localName.

@param {(String | null)} namespace string | null
@param {String} localName
@returns {Boolean}
**/
HTMLAudioElement.prototype.hasAttributeNS = function(namespace, localName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns true if element has attributes, and false otherwise.

@returns {Boolean}
**/
HTMLAudioElement.prototype.hasAttributes = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} pointerId
@returns {Boolean}
**/
HTMLAudioElement.prototype.hasPointerCapture = function(pointerId) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {("beforebegin" | "afterbegin" | "beforeend" | "afterend")} where InsertPosition
@param {Element} element Element
@returns {(Element | null)} Element | null
**/
HTMLAudioElement.prototype.insertAdjacentElement = function(where, element) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {("beforebegin" | "afterbegin" | "beforeend" | "afterend")} position InsertPosition
@param {String} text
@returns {undefined}
**/
HTMLAudioElement.prototype.insertAdjacentHTML = function(position, text) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {("beforebegin" | "afterbegin" | "beforeend" | "afterend")} where InsertPosition
@param {String} data
@returns {undefined}
**/
HTMLAudioElement.prototype.insertAdjacentText = function(where, data) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns true if matching selectors against element's root yields element, and false otherwise.

@param {String} selectors
@returns {Boolean}
**/
HTMLAudioElement.prototype.matches = function(selectors) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} pointerId
@returns {undefined}
**/
HTMLAudioElement.prototype.releasePointerCapture = function(pointerId) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes element's first attribute whose qualified name is qualifiedName.

@param {String} qualifiedName
@returns {undefined}
**/
HTMLAudioElement.prototype.removeAttribute = function(qualifiedName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes element's attribute whose namespace is namespace and local name is localName.

@param {(String | null)} namespace string | null
@param {String} localName
@returns {undefined}
**/
HTMLAudioElement.prototype.removeAttributeNS = function(namespace, localName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Attr} attr Attr
@returns {Attr}
**/
HTMLAudioElement.prototype.removeAttributeNode = function(attr) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Displays element fullscreen and resolves promise when done.

When supplied, options's navigationUI member indicates whether showing navigation UI while in fullscreen is preferred or not. If set to "show", navigation simplicity is preferred over screen space, and if set to "hide", more screen space is preferred. User agents are always free to honor user preference over the application's. The default value "auto" indicates no application preference.

@param {FullscreenOptions} [options] FullscreenOptions
@returns {Promise}
**/
HTMLAudioElement.prototype.requestFullscreen = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {undefined}
**/
HTMLAudioElement.prototype.requestPointerLock = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x
@param {Number} y
@returns {undefined}
**/
HTMLAudioElement.prototype.scroll = function(x, y) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x
@param {Number} y
@returns {undefined}
**/
HTMLAudioElement.prototype.scrollBy = function(x, y) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(Boolean | ScrollIntoViewOptions)} [arg] boolean | ScrollIntoViewOptions
@returns {undefined}
**/
HTMLAudioElement.prototype.scrollIntoView = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x
@param {Number} y
@returns {undefined}
**/
HTMLAudioElement.prototype.scrollTo = function(x, y) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Sets the value of element's first attribute whose qualified name is qualifiedName to value.

@param {String} qualifiedName
@param {String} value
@returns {undefined}
**/
HTMLAudioElement.prototype.setAttribute = function(qualifiedName, value) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Sets the value of element's attribute whose namespace is namespace and local name is localName to value.

@param {(String | null)} namespace string | null
@param {String} qualifiedName
@param {String} value
@returns {undefined}
**/
HTMLAudioElement.prototype.setAttributeNS = function(namespace, qualifiedName, value) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Attr} attr Attr
@returns {(Attr | null)} Attr | null
**/
HTMLAudioElement.prototype.setAttributeNode = function(attr) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Attr} attr Attr
@returns {(Attr | null)} Attr | null
**/
HTMLAudioElement.prototype.setAttributeNodeNS = function(attr) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} pointerId
@returns {undefined}
**/
HTMLAudioElement.prototype.setPointerCapture = function(pointerId) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
If force is not given, "toggles" qualifiedName, removing it if it is present and adding it if it is not present. If force is true, adds qualifiedName. If force is false, removes qualifiedName.

Returns true if qualifiedName is now present, and false otherwise.

@param {String} qualifiedName
@param {Boolean} [force]
@returns {Boolean}
**/
HTMLAudioElement.prototype.toggleAttribute = function(qualifiedName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} selectors
@returns {Boolean}
**/
HTMLAudioElement.prototype.webkitMatchesSelector = function(selectors) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | AddEventListenerOptions)} [options] boolean | AddEventListenerOptions
@returns {undefined}
**/
HTMLAudioElement.prototype.addEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | EventListenerOptions)} [options] boolean | EventListenerOptions
@returns {undefined}
**/
HTMLAudioElement.prototype.removeEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.baseURI = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {NodeListOf}
**/
HTMLAudioElement.prototype.childNodes = new NodeListOf();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLAudioElement.prototype.firstChild = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLAudioElement.prototype.isConnected = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLAudioElement.prototype.lastChild = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLAudioElement.prototype.nextSibling = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.nodeName = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.nodeType = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.nodeValue = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Document | null)} Document | null
**/
HTMLAudioElement.prototype.ownerDocument = new Document();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(HTMLElement | null)} HTMLElement | null
**/
HTMLAudioElement.prototype.parentElement = new HTMLElement();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ParentNode | null)} ParentNode | null
**/
HTMLAudioElement.prototype.parentNode = new ParentNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLAudioElement.prototype.previousSibling = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.textContent = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} node T
@returns {Object} T
**/
HTMLAudioElement.prototype.appendChild = function(node) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a copy of node. If deep is true, the copy also includes the node's descendants.

@param {Boolean} [deep]
@returns {Node}
**/
HTMLAudioElement.prototype.cloneNode = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a bitmask indicating the position of other relative to node.

@param {Node} other Node
@returns {Number}
**/
HTMLAudioElement.prototype.compareDocumentPosition = function(other) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns true if other is an inclusive descendant of node, and false otherwise.

@param {(Node | null)} other Node | null
@returns {Boolean}
**/
HTMLAudioElement.prototype.contains = function(other) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns node's root.

@param {GetRootNodeOptions} [options] GetRootNodeOptions
@returns {Node}
**/
HTMLAudioElement.prototype.getRootNode = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns whether node has children.

@returns {Boolean}
**/
HTMLAudioElement.prototype.hasChildNodes = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} node T
@param {(Node | null)} child Node | null
@returns {Object} T
**/
HTMLAudioElement.prototype.insertBefore = function(node, child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@returns {Boolean}
**/
HTMLAudioElement.prototype.isDefaultNamespace = function(namespace) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns whether node and otherNode have the same properties.

@param {(Node | null)} otherNode Node | null
@returns {Boolean}
**/
HTMLAudioElement.prototype.isEqualNode = function(otherNode) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(Node | null)} otherNode Node | null
@returns {Boolean}
**/
HTMLAudioElement.prototype.isSameNode = function(otherNode) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} prefix string | null
@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.lookupNamespaceURI = function(prefix) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.lookupPrefix = function(namespace) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes empty exclusive Text nodes and concatenates the data of remaining contiguous exclusive Text nodes into the first of their nodes.

@returns {undefined}
**/
HTMLAudioElement.prototype.normalize = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} child T
@returns {Object} T
**/
HTMLAudioElement.prototype.removeChild = function(child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Node} node Node
@param {Object} child T
@returns {Object} T
**/
HTMLAudioElement.prototype.replaceChild = function(node, child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.ATTRIBUTE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.CDATA_SECTION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.COMMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_FRAGMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_POSITION_CONTAINED_BY = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_POSITION_CONTAINS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_POSITION_DISCONNECTED = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_POSITION_FOLLOWING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_POSITION_PRECEDING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_TYPE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.ELEMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.ENTITY_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.ENTITY_REFERENCE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.NOTATION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.PROCESSING_INSTRUCTION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.TEXT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(AddEventListenerOptions | Boolean)} [options] AddEventListenerOptions | boolean
@returns {undefined}
**/
HTMLAudioElement.prototype.addEventListener = function(type, callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Dispatches a synthetic event event to target and returns true if either event's cancelable attribute value is false or its preventDefault() method was not invoked, and false otherwise.

@param {Event} event Event
@returns {Boolean}
**/
HTMLAudioElement.prototype.dispatchEvent = function(event) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(EventListenerOptions | Boolean)} [options] EventListenerOptions | boolean
@returns {undefined}
**/
HTMLAudioElement.prototype.removeEventListener = function(type, callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaAtomic = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaAutoComplete = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaBusy = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaChecked = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaColCount = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaColIndex = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaColSpan = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaCurrent = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaDisabled = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaExpanded = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaHasPopup = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaHidden = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaKeyShortcuts = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaLabel = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaLevel = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaLive = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaModal = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaMultiLine = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaMultiSelectable = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaOrientation = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaPlaceholder = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaPosInSet = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaPressed = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaReadOnly = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaRequired = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaRoleDescription = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaRowCount = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaRowIndex = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaRowSpan = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaSelected = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaSetSize = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaSort = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaValueMax = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaValueMin = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaValueNow = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.ariaValueText = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(Keyframe[] | PropertyIndexedKeyframes | null)} keyframes Keyframe[] | PropertyIndexedKeyframes | null
@param {(Number | KeyframeAnimationOptions)} [options] number | KeyframeAnimationOptions
@returns {Animation}
**/
HTMLAudioElement.prototype.animate = function(keyframes) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {GetAnimationsOptions} [options] GetAnimationsOptions
@returns {Animation[]}
**/
HTMLAudioElement.prototype.getAnimations = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Inserts nodes just after node, while replacing strings in nodes with equivalent Text nodes.

Throws a "HierarchyRequestError" DOMException if the constraints of the node tree are violated.

@param {(Node | String)} nodes (Node | string)[]
@returns {undefined}
**/
HTMLAudioElement.prototype.after = function(nodes) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Inserts nodes just before node, while replacing strings in nodes with equivalent Text nodes.

Throws a "HierarchyRequestError" DOMException if the constraints of the node tree are violated.

@param {(Node | String)} nodes (Node | string)[]
@returns {undefined}
**/
HTMLAudioElement.prototype.before = function(nodes) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes node.

@returns {undefined}
**/
HTMLAudioElement.prototype.remove = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Replaces node with nodes, while replacing strings in nodes with equivalent Text nodes.

Throws a "HierarchyRequestError" DOMException if the constraints of the node tree are violated.

@param {(Node | String)} nodes (Node | string)[]
@returns {undefined}
**/
HTMLAudioElement.prototype.replaceWith = function(nodes) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.baseURI = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {NodeListOf}
**/
HTMLAudioElement.prototype.childNodes = new NodeListOf();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLAudioElement.prototype.firstChild = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLAudioElement.prototype.isConnected = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLAudioElement.prototype.lastChild = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLAudioElement.prototype.nextSibling = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.nodeName = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.nodeType = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.nodeValue = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Document | null)} Document | null
**/
HTMLAudioElement.prototype.ownerDocument = new Document();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(HTMLElement | null)} HTMLElement | null
**/
HTMLAudioElement.prototype.parentElement = new HTMLElement();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ParentNode | null)} ParentNode | null
**/
HTMLAudioElement.prototype.parentNode = new ParentNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLAudioElement.prototype.previousSibling = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.textContent = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} node T
@returns {Object} T
**/
HTMLAudioElement.prototype.appendChild = function(node) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a copy of node. If deep is true, the copy also includes the node's descendants.

@param {Boolean} [deep]
@returns {Node}
**/
HTMLAudioElement.prototype.cloneNode = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a bitmask indicating the position of other relative to node.

@param {Node} other Node
@returns {Number}
**/
HTMLAudioElement.prototype.compareDocumentPosition = function(other) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns true if other is an inclusive descendant of node, and false otherwise.

@param {(Node | null)} other Node | null
@returns {Boolean}
**/
HTMLAudioElement.prototype.contains = function(other) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns node's root.

@param {GetRootNodeOptions} [options] GetRootNodeOptions
@returns {Node}
**/
HTMLAudioElement.prototype.getRootNode = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns whether node has children.

@returns {Boolean}
**/
HTMLAudioElement.prototype.hasChildNodes = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} node T
@param {(Node | null)} child Node | null
@returns {Object} T
**/
HTMLAudioElement.prototype.insertBefore = function(node, child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@returns {Boolean}
**/
HTMLAudioElement.prototype.isDefaultNamespace = function(namespace) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns whether node and otherNode have the same properties.

@param {(Node | null)} otherNode Node | null
@returns {Boolean}
**/
HTMLAudioElement.prototype.isEqualNode = function(otherNode) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(Node | null)} otherNode Node | null
@returns {Boolean}
**/
HTMLAudioElement.prototype.isSameNode = function(otherNode) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} prefix string | null
@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.lookupNamespaceURI = function(prefix) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.lookupPrefix = function(namespace) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes empty exclusive Text nodes and concatenates the data of remaining contiguous exclusive Text nodes into the first of their nodes.

@returns {undefined}
**/
HTMLAudioElement.prototype.normalize = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} child T
@returns {Object} T
**/
HTMLAudioElement.prototype.removeChild = function(child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Node} node Node
@param {Object} child T
@returns {Object} T
**/
HTMLAudioElement.prototype.replaceChild = function(node, child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.ATTRIBUTE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.CDATA_SECTION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.COMMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_FRAGMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_POSITION_CONTAINED_BY = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_POSITION_CONTAINS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_POSITION_DISCONNECTED = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_POSITION_FOLLOWING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_POSITION_PRECEDING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_TYPE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.ELEMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.ENTITY_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.ENTITY_REFERENCE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.NOTATION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.PROCESSING_INSTRUCTION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.TEXT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(AddEventListenerOptions | Boolean)} [options] AddEventListenerOptions | boolean
@returns {undefined}
**/
HTMLAudioElement.prototype.addEventListener = function(type, callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Dispatches a synthetic event event to target and returns true if either event's cancelable attribute value is false or its preventDefault() method was not invoked, and false otherwise.

@param {Event} event Event
@returns {Boolean}
**/
HTMLAudioElement.prototype.dispatchEvent = function(event) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(EventListenerOptions | Boolean)} [options] EventListenerOptions | boolean
@returns {undefined}
**/
HTMLAudioElement.prototype.removeEventListener = function(type, callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.innerHTML = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Element | null)} Element | null
**/
HTMLAudioElement.prototype.nextElementSibling = new Element();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Element | null)} Element | null
**/
HTMLAudioElement.prototype.previousElementSibling = new Element();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.childElementCount = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {HTMLCollection}
**/
HTMLAudioElement.prototype.children = new HTMLCollection();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Element | null)} Element | null
**/
HTMLAudioElement.prototype.firstElementChild = new Element();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Element | null)} Element | null
**/
HTMLAudioElement.prototype.lastElementChild = new Element();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Inserts nodes after the last child of node, while replacing strings in nodes with equivalent Text nodes.

Throws a "HierarchyRequestError" DOMException if the constraints of the node tree are violated.

@param {(Node | String)} nodes (Node | string)[]
@returns {undefined}
**/
HTMLAudioElement.prototype.append = function(nodes) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Inserts nodes before the first child of node, while replacing strings in nodes with equivalent Text nodes.

Throws a "HierarchyRequestError" DOMException if the constraints of the node tree are violated.

@param {(Node | String)} nodes (Node | string)[]
@returns {undefined}
**/
HTMLAudioElement.prototype.prepend = function(nodes) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns the first element that is a descendant of node that matches selectors.

@param {String} selectors
@returns {(Object | null)} E | null
**/
HTMLAudioElement.prototype.querySelector = function(selectors) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns all element descendants of node that match selectors.

@param {String} selectors
@returns {NodeListOf}
**/
HTMLAudioElement.prototype.querySelectorAll = function(selectors) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Replace all children of node with nodes, while replacing strings in nodes with equivalent Text nodes.

Throws a "HierarchyRequestError" DOMException if the constraints of the node tree are violated.

@param {(Node | String)} nodes (Node | string)[]
@returns {undefined}
**/
HTMLAudioElement.prototype.replaceChildren = function(nodes) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.baseURI = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {NodeListOf}
**/
HTMLAudioElement.prototype.childNodes = new NodeListOf();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLAudioElement.prototype.firstChild = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLAudioElement.prototype.isConnected = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLAudioElement.prototype.lastChild = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLAudioElement.prototype.nextSibling = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.nodeName = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.nodeType = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.nodeValue = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Document | null)} Document | null
**/
HTMLAudioElement.prototype.ownerDocument = new Document();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(HTMLElement | null)} HTMLElement | null
**/
HTMLAudioElement.prototype.parentElement = new HTMLElement();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ParentNode | null)} ParentNode | null
**/
HTMLAudioElement.prototype.parentNode = new ParentNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLAudioElement.prototype.previousSibling = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.textContent = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} node T
@returns {Object} T
**/
HTMLAudioElement.prototype.appendChild = function(node) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a copy of node. If deep is true, the copy also includes the node's descendants.

@param {Boolean} [deep]
@returns {Node}
**/
HTMLAudioElement.prototype.cloneNode = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a bitmask indicating the position of other relative to node.

@param {Node} other Node
@returns {Number}
**/
HTMLAudioElement.prototype.compareDocumentPosition = function(other) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns true if other is an inclusive descendant of node, and false otherwise.

@param {(Node | null)} other Node | null
@returns {Boolean}
**/
HTMLAudioElement.prototype.contains = function(other) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns node's root.

@param {GetRootNodeOptions} [options] GetRootNodeOptions
@returns {Node}
**/
HTMLAudioElement.prototype.getRootNode = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns whether node has children.

@returns {Boolean}
**/
HTMLAudioElement.prototype.hasChildNodes = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} node T
@param {(Node | null)} child Node | null
@returns {Object} T
**/
HTMLAudioElement.prototype.insertBefore = function(node, child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@returns {Boolean}
**/
HTMLAudioElement.prototype.isDefaultNamespace = function(namespace) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns whether node and otherNode have the same properties.

@param {(Node | null)} otherNode Node | null
@returns {Boolean}
**/
HTMLAudioElement.prototype.isEqualNode = function(otherNode) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(Node | null)} otherNode Node | null
@returns {Boolean}
**/
HTMLAudioElement.prototype.isSameNode = function(otherNode) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} prefix string | null
@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.lookupNamespaceURI = function(prefix) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@returns {(String | null)} string | null
**/
HTMLAudioElement.prototype.lookupPrefix = function(namespace) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes empty exclusive Text nodes and concatenates the data of remaining contiguous exclusive Text nodes into the first of their nodes.

@returns {undefined}
**/
HTMLAudioElement.prototype.normalize = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} child T
@returns {Object} T
**/
HTMLAudioElement.prototype.removeChild = function(child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Node} node Node
@param {Object} child T
@returns {Object} T
**/
HTMLAudioElement.prototype.replaceChild = function(node, child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.ATTRIBUTE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.CDATA_SECTION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.COMMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_FRAGMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_POSITION_CONTAINED_BY = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_POSITION_CONTAINS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_POSITION_DISCONNECTED = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_POSITION_FOLLOWING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_POSITION_PRECEDING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.DOCUMENT_TYPE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.ELEMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.ENTITY_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.ENTITY_REFERENCE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.NOTATION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.PROCESSING_INSTRUCTION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.TEXT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(AddEventListenerOptions | Boolean)} [options] AddEventListenerOptions | boolean
@returns {undefined}
**/
HTMLAudioElement.prototype.addEventListener = function(type, callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Dispatches a synthetic event event to target and returns true if either event's cancelable attribute value is false or its preventDefault() method was not invoked, and false otherwise.

@param {Event} event Event
@returns {Boolean}
**/
HTMLAudioElement.prototype.dispatchEvent = function(event) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(EventListenerOptions | Boolean)} [options] EventListenerOptions | boolean
@returns {undefined}
**/
HTMLAudioElement.prototype.removeEventListener = function(type, callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(HTMLSlotElement | null)} HTMLSlotElement | null
**/
HTMLAudioElement.prototype.assignedSlot = new HTMLSlotElement();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: DocumentAndElementEventHandlers, ev: ClipboardEvent) => any) | null
**/
HTMLAudioElement.prototype.oncopy = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: DocumentAndElementEventHandlers, ev: ClipboardEvent) => any) | null
**/
HTMLAudioElement.prototype.oncut = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: DocumentAndElementEventHandlers, ev: ClipboardEvent) => any) | null
**/
HTMLAudioElement.prototype.onpaste = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | AddEventListenerOptions)} [options] boolean | AddEventListenerOptions
@returns {undefined}
**/
HTMLAudioElement.prototype.addEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | EventListenerOptions)} [options] boolean | EventListenerOptions
@returns {undefined}
**/
HTMLAudioElement.prototype.removeEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {CSSStyleDeclaration}
**/
HTMLAudioElement.prototype.style = new CSSStyleDeclaration();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.contentEditable = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.enterKeyHint = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.inputMode = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLAudioElement.prototype.isContentEditable = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: UIEvent) => any) | null
**/
HTMLAudioElement.prototype.onabort = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null
**/
HTMLAudioElement.prototype.onanimationcancel = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null
**/
HTMLAudioElement.prototype.onanimationend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null
**/
HTMLAudioElement.prototype.onanimationiteration = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null
**/
HTMLAudioElement.prototype.onanimationstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLAudioElement.prototype.onauxclick = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: FocusEvent) => any) | null
**/
HTMLAudioElement.prototype.onblur = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.oncanplay = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.oncanplaythrough = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onchange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLAudioElement.prototype.onclick = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onclose = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLAudioElement.prototype.oncontextmenu = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.oncuechange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLAudioElement.prototype.ondblclick = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
HTMLAudioElement.prototype.ondrag = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
HTMLAudioElement.prototype.ondragend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
HTMLAudioElement.prototype.ondragenter = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
HTMLAudioElement.prototype.ondragleave = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
HTMLAudioElement.prototype.ondragover = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
HTMLAudioElement.prototype.ondragstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
HTMLAudioElement.prototype.ondrop = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.ondurationchange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onemptied = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onended = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(OnErrorEventHandlerNonNull | null)} OnErrorEventHandler
**/
HTMLAudioElement.prototype.onerror = new OnErrorEventHandlerNonNull();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: FocusEvent) => any) | null
**/
HTMLAudioElement.prototype.onfocus = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: FormDataEvent) => any) | null
**/
HTMLAudioElement.prototype.onformdata = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLAudioElement.prototype.ongotpointercapture = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.oninput = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.oninvalid = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null
**/
HTMLAudioElement.prototype.onkeydown = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null
**/
HTMLAudioElement.prototype.onkeypress = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null
**/
HTMLAudioElement.prototype.onkeyup = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onload = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onloadeddata = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onloadedmetadata = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onloadstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLAudioElement.prototype.onlostpointercapture = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLAudioElement.prototype.onmousedown = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLAudioElement.prototype.onmouseenter = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLAudioElement.prototype.onmouseleave = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLAudioElement.prototype.onmousemove = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLAudioElement.prototype.onmouseout = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLAudioElement.prototype.onmouseover = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLAudioElement.prototype.onmouseup = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onpause = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onplay = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onplaying = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLAudioElement.prototype.onpointercancel = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLAudioElement.prototype.onpointerdown = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLAudioElement.prototype.onpointerenter = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLAudioElement.prototype.onpointerleave = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLAudioElement.prototype.onpointermove = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLAudioElement.prototype.onpointerout = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLAudioElement.prototype.onpointerover = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLAudioElement.prototype.onpointerup = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: ProgressEvent) => any) | null
**/
HTMLAudioElement.prototype.onprogress = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onratechange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onreset = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: UIEvent) => any) | null
**/
HTMLAudioElement.prototype.onresize = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onscroll = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: SecurityPolicyViolationEvent) => any) | null
**/
HTMLAudioElement.prototype.onsecuritypolicyviolation = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onseeked = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onseeking = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onselect = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onselectionchange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onselectstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onslotchange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onstalled = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: SubmitEvent) => any) | null
**/
HTMLAudioElement.prototype.onsubmit = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onsuspend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.ontimeupdate = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.ontoggle = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null | undefined)} ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined
**/
HTMLAudioElement.prototype.ontouchcancel = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null | undefined)} ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined
**/
HTMLAudioElement.prototype.ontouchend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null | undefined)} ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined
**/
HTMLAudioElement.prototype.ontouchmove = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null | undefined)} ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined
**/
HTMLAudioElement.prototype.ontouchstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null
**/
HTMLAudioElement.prototype.ontransitioncancel = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null
**/
HTMLAudioElement.prototype.ontransitionend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null
**/
HTMLAudioElement.prototype.ontransitionrun = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null
**/
HTMLAudioElement.prototype.ontransitionstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onvolumechange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onwaiting = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onwebkitanimationend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onwebkitanimationiteration = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onwebkitanimationstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLAudioElement.prototype.onwebkittransitionend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: WheelEvent) => any) | null
**/
HTMLAudioElement.prototype.onwheel = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | AddEventListenerOptions)} [options] boolean | AddEventListenerOptions
@returns {undefined}
**/
HTMLAudioElement.prototype.addEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | EventListenerOptions)} [options] boolean | EventListenerOptions
@returns {undefined}
**/
HTMLAudioElement.prototype.removeEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLAudioElement.prototype.autofocus = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {DOMStringMap}
**/
HTMLAudioElement.prototype.dataset = new DOMStringMap();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLAudioElement.prototype.nonce = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLAudioElement.prototype.tabIndex = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {undefined}
**/
HTMLAudioElement.prototype.blur = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {FocusOptions} [options] FocusOptions
@returns {undefined}
**/
HTMLAudioElement.prototype.focus = function() {};

