/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.common.util;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class Utility {
    public static final String LOGGING_DOMAIN = "javax.enterprise.resource.webservices.registry";
    Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.registry.common");
    private static Utility instance = null;
    private String jaxrHome = null;

    protected Utility() {
    }

    public void setJAXRHome(String jaxrHome) {
        this.jaxrHome = jaxrHome;
    }

    public String getJAXRHome() {
        this.logger.finest("getJAXRHome() called");
        if (this.jaxrHome == null) {
            try {
                this.jaxrHome = System.getProperty("JAXR_HOME");
                if (this.jaxrHome == null) {
                    throw new NullPointerException();
                }
            }
            catch (NullPointerException npe) {
                throw new RuntimeException(ResourceBundle.getBundle("com/sun/xml/registry/common/LocalStrings").getString("Utility:JAXR_HOME_must_be_set"), npe);
            }
        }
        return this.jaxrHome;
    }

    public String getContextRoot() {
        String contextRoot = "c:/jaxr";
        try {
            InitialContext context = new InitialContext();
            contextRoot = (String)context.lookup("java:comp/env/jaxr-service/contextRoot");
        }
        catch (NamingException e) {
            System.getProperty("JAXR_HOME", "c:/jaxr");
        }
        return contextRoot;
    }

    public String getContextRootURLString() {
        String contextRoot = this.getContextRoot();
        if (!contextRoot.startsWith("http", 0) && !contextRoot.startsWith("file", 0)) {
            contextRoot = "file:///" + contextRoot;
        }
        return contextRoot;
    }

    public URL getURL(String urlSuffix) throws MalformedURLException {
        URL url = null;
        String contextRootURLString = this.getContextRootURLString() + urlSuffix;
        url = new URL(contextRootURLString);
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Utility getInstance() {
        if (instance != null) return instance;
        Class<Utility> clazz = Utility.class;
        synchronized (Utility.class) {
            if (instance != null) return instance;
            instance = new Utility();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static String generateUUID() {
        String uuid = null;
        try {
            uuid = InetAddress.getLocalHost() + new UID().toString();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return uuid;
    }
}

