/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.laf.flatlaf.ui;

import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.netbeans.swing.laf.flatlaf.HiDPIUtils;
import org.netbeans.swing.laf.flatlaf.ui.FlatTabControlIcon;
import org.netbeans.swing.laf.flatlaf.ui.Utils;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabPainter;

public class FlatEditorTabCellRenderer
extends AbstractTabCellRenderer {
    private static final Color background = UIManager.getColor("EditorTab.background");
    private static final Color activeBackground = Utils.getUIColor("EditorTab.activeBackground", background);
    private static final Color selectedBackground = Utils.getUIColor("EditorTab.selectedBackground", activeBackground);
    private static final Color selectedBackgroundBottomGradient = Utils.getUIColor("EditorTab.selectedBackgroundBottomGradient", selectedBackground);
    private static final Color hoverBackground = UIManager.getColor("EditorTab.hoverBackground");
    private static final Color selectedHoverBackground = Utils.getUIColor("EditorTab.selectedHoverBackground", hoverBackground);
    private static final Color attentionBackground = UIManager.getColor("EditorTab.attentionBackground");
    private static final Color foreground = Utils.getUIColor("EditorTab.foreground", "TabbedPane.foreground");
    private static final Color activeForeground = Utils.getUIColor("EditorTab.activeForeground", foreground);
    private static final Color selectedForeground = Utils.getUIColor("EditorTab.selectedForeground", activeForeground);
    private static final Color hoverForeground = Utils.getUIColor("EditorTab.hoverForeground", foreground);
    private static final Color selectedHoverForeground = Utils.getUIColor("EditorTab.selectedHoverForeground", hoverForeground);
    private static final Color attentionForeground = Utils.getUIColor("EditorTab.attentionForeground", foreground);
    private static final Color underlineColor = UIManager.getColor("EditorTab.underlineColor");
    private static final Color inactiveUnderlineColor = UIManager.getColor("EditorTab.inactiveUnderlineColor");
    private static final Color tabSeparatorColor = UIManager.getColor("EditorTab.tabSeparatorColor");
    private static final Color contentBorderColor = UIManager.getColor("TabbedContainer.editor.contentBorderColor");
    private static final Insets tabInsets = UIScale.scale((Insets)UIManager.getInsets("EditorTab.tabInsets"));
    private static final int underlineHeight = UIScale.scale((int)UIManager.getInt("EditorTab.underlineHeight"));
    private static final boolean underlineAtTop = UIManager.getBoolean("EditorTab.underlineAtTop");
    private static boolean showTabSeparators = UIManager.getBoolean("EditorTab.showTabSeparators");
    private static final int CLOSE_ICON_RIGHT_PAD = FlatEditorTabCellRenderer.tabInsets.left - 2;
    private static final boolean showSelectedTabBorder = Utils.getUIBoolean("EditorTab.showSelectedTabBorder", underlineAtTop);
    private static final boolean unscaledBorders = Utils.getUIBoolean("EditorTab.unscaledBorders", false);
    private static final FlatTabPainter leftClipPainter = new FlatTabPainter(true, false);
    private static final FlatTabPainter noClipPainter = new FlatTabPainter(false, false);
    private static final FlatTabPainter rightClipPainter = new FlatTabPainter(false, true);
    boolean firstTab;
    boolean lastTab;
    boolean nextTabSelected;

    public FlatEditorTabCellRenderer() {
        super((TabPainter)leftClipPainter, (TabPainter)noClipPainter, (TabPainter)rightClipPainter, new Dimension(FlatEditorTabCellRenderer.tabInsets.left + FlatEditorTabCellRenderer.tabInsets.right, FlatEditorTabCellRenderer.tabInsets.top + FlatEditorTabCellRenderer.tabInsets.bottom));
    }

    public Dimension getPadding() {
        Dimension d = super.getPadding();
        if (this.isShowCloseButton() && !Boolean.getBoolean("nb.tabs.suppressCloseButton")) {
            d.width += this.findCloseIcon().getIconWidth() + UIScale.scale((int)CLOSE_ICON_RIGHT_PAD);
        }
        return d;
    }

    protected int getCaptionYPosition(Graphics g) {
        Font font = this.getFont();
        FontRenderContext frc = g instanceof Graphics2D ? ((Graphics2D)g).getFontRenderContext() : g.getFontMetrics(font).getFontRenderContext();
        double txtVisualAscent = font.createGlyphVector(frc, "H").getVisualBounds().getHeight();
        Insets ins = this.getInsets();
        int availH = this.getHeight() - (ins.top + ins.bottom);
        int effectiveIconYAdjustment = 2 + this.getIconYAdjustment();
        return ins.top + (int)Math.round(((double)availH + txtVisualAscent) / 2.0) + effectiveIconYAdjustment;
    }

    protected int stateChanged(int oldState, int newState) {
        int result = super.stateChanged(oldState, newState);
        this.setForeground(this.colorForState(foreground, activeForeground, selectedForeground, selectedHoverForeground, hoverForeground, attentionForeground));
        return result;
    }

    private Color colorForState(Color normal, Color active, Color selected, Color selectedHover, Color unselectedHover, Color attention) {
        return this.isAttention() ? attention : (this.isArmed() ? (this.isSelected() ? selectedHover : unselectedHover) : (this.isSelected() ? selected : (this.isActive() ? active : normal)));
    }

    private Icon findCloseIcon() {
        return FlatTabControlIcon.get(1, this.inCloseButton() ? (this.isPressed() ? 1 : 3) : 0);
    }

    private static class FlatTabPainter
    implements TabPainter {
        final boolean leftClip;
        final boolean rightClip;

        public FlatTabPainter(boolean leftClip, boolean rightClip) {
            this.leftClip = leftClip;
            this.rightClip = rightClip;
        }

        public Insets getBorderInsets(Component c) {
            return tabInsets;
        }

        public void getCloseButtonRectangle(JComponent jc, Rectangle rect, Rectangle bounds) {
            FlatEditorTabCellRenderer ren = (FlatEditorTabCellRenderer)((Object)jc);
            if (!ren.isShowCloseButton() || this.leftClip || this.rightClip) {
                rect.x = -100;
                rect.y = -100;
                rect.width = 0;
                rect.height = 0;
                return;
            }
            Icon icon = ren.findCloseIcon();
            int iconWidth = icon.getIconWidth();
            int iconHeight = icon.getIconHeight();
            rect.x = bounds.x + bounds.width - iconWidth - UIScale.scale((int)CLOSE_ICON_RIGHT_PAD);
            int yAdjustment = 2;
            rect.y = bounds.y + Math.max(0, (bounds.height - iconHeight) / 2) - 1 + yAdjustment;
            rect.width = iconWidth;
            rect.height = iconHeight;
        }

        public Polygon getInteriorPolygon(Component c) {
            int x = 0;
            int y = 0;
            int width = c.getWidth();
            int height = c.getHeight();
            Polygon p = new Polygon();
            p.addPoint(x, y);
            p.addPoint(x + width, y);
            p.addPoint(x + width, y + height);
            p.addPoint(x, y + height);
            return p;
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        }

        public void paintInterior(Graphics g, Component c) {
            HiDPIUtils.paintAtScale1x(g, 0, 0, c.getWidth(), c.getHeight(), (gd, width, height, scale) -> this.paintInteriorAtScale1x(gd, c, width, height, scale));
            FlatEditorTabCellRenderer ren = (FlatEditorTabCellRenderer)((Object)c);
            if (!ren.isClipLeft() && !ren.isClipRight()) {
                this.paintCloseButton(g, ren);
            }
        }

        private static void fillGradientRect(Graphics2D g, int x, int y, int width, int height, Color color, Color bottomGradient, int gradientOffset) {
            if (bottomGradient.equals(color)) {
                g.setColor(color);
            } else {
                g.setPaint(new GradientPaint(0.0f, y + gradientOffset, color, 0.0f, y + height - gradientOffset, bottomGradient, false));
            }
            g.fillRect(x, y, width, height);
        }

        private void paintInteriorAtScale1x(Graphics2D g, Component c, int width, int height, double scale) {
            FlatEditorTabCellRenderer ren = (FlatEditorTabCellRenderer)((Object)c);
            boolean selected = ren.isSelected();
            Color bg = ren.colorForState(background, activeBackground, selectedBackground, selectedHoverBackground, hoverBackground, attentionBackground);
            boolean showSeparator = showTabSeparators && !selected && !ren.nextTabSelected && !ren.lastTab && !this.rightClip;
            int contentBorderWidth = unscaledBorders ? 1 : HiDPIUtils.deviceBorderWidth(scale, 1);
            int tabSeparatorWidth = showSeparator ? contentBorderWidth : 0;
            int underlineHeight = (int)Math.round((double)underlineHeight * scale);
            FlatTabPainter.fillGradientRect(g, 0, 0, width - (bg != background ? tabSeparatorWidth : 0), height, bg, selected && !selectedBackground.equals(selectedBackgroundBottomGradient) ? selectedBackgroundBottomGradient : bg, underlineAtTop ? underlineHeight : 0);
            if (selected) {
                if (showSelectedTabBorder) {
                    g.setColor(contentBorderColor);
                    g.fillRect(0, 0, width - tabSeparatorWidth, contentBorderWidth);
                    if (!this.leftClip) {
                        g.fillRect(0, 0, contentBorderWidth, height);
                    }
                    if (!this.rightClip) {
                        g.fillRect(width - tabSeparatorWidth - contentBorderWidth, 0, contentBorderWidth, height);
                    }
                }
                if (underlineHeight > 0) {
                    g.setColor(ren.isActive() ? underlineColor : inactiveUnderlineColor);
                    if (underlineAtTop) {
                        g.fillRect(0, 0, width - tabSeparatorWidth, underlineHeight);
                    } else {
                        g.fillRect(0, height - underlineHeight, width - tabSeparatorWidth, underlineHeight);
                    }
                }
            } else {
                g.setColor(contentBorderColor);
                g.fillRect(0, height - contentBorderWidth, width, contentBorderWidth);
            }
            if (showSeparator) {
                int offset = (int)(4.0 * scale);
                g.setColor(tabSeparatorColor);
                g.fillRect(width - tabSeparatorWidth, offset, tabSeparatorWidth, height - offset * 2 - 1);
            }
        }

        private void paintCloseButton(Graphics g, FlatEditorTabCellRenderer ren) {
            Rectangle r = new Rectangle();
            this.getCloseButtonRectangle((JComponent)((Object)ren), r, new Rectangle(0, 0, ren.getWidth(), ren.getHeight()));
            if (!g.hitClip(r.x, r.y, r.width, r.height)) {
                return;
            }
            Icon icon = ren.findCloseIcon();
            icon.paintIcon((Component)((Object)ren), g, r.x, r.y);
        }

        public boolean supportsCloseButton(JComponent renderer) {
            return renderer instanceof TabDisplayer ? ((TabDisplayer)renderer).isShowCloseButton() : true;
        }
    }
}

