/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetUserGroupMembershipRequest
extends BmcRequest<Void> {
    private String userGroupMembershipId;

    public String getUserGroupMembershipId() {
        return this.userGroupMembershipId;
    }

    public Builder toBuilder() {
        return new Builder().userGroupMembershipId(this.userGroupMembershipId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",userGroupMembershipId=").append(String.valueOf(this.userGroupMembershipId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetUserGroupMembershipRequest)) {
            return false;
        }
        GetUserGroupMembershipRequest other = (GetUserGroupMembershipRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.userGroupMembershipId, other.userGroupMembershipId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.userGroupMembershipId == null ? 43 : this.userGroupMembershipId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetUserGroupMembershipRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String userGroupMembershipId = null;

        public Builder userGroupMembershipId(String userGroupMembershipId) {
            this.userGroupMembershipId = userGroupMembershipId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetUserGroupMembershipRequest o) {
            this.userGroupMembershipId(o.getUserGroupMembershipId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetUserGroupMembershipRequest build() {
            GetUserGroupMembershipRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetUserGroupMembershipRequest buildWithoutInvocationCallback() {
            GetUserGroupMembershipRequest request = new GetUserGroupMembershipRequest();
            request.userGroupMembershipId = this.userGroupMembershipId;
            return request;
        }
    }
}

