/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetGroupRequest
extends BmcRequest<Void> {
    private String groupId;

    public String getGroupId() {
        return this.groupId;
    }

    public Builder toBuilder() {
        return new Builder().groupId(this.groupId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",groupId=").append(String.valueOf(this.groupId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetGroupRequest)) {
            return false;
        }
        GetGroupRequest other = (GetGroupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.groupId, other.groupId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.groupId == null ? 43 : this.groupId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetGroupRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String groupId = null;

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetGroupRequest o) {
            this.groupId(o.getGroupId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetGroupRequest build() {
            GetGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetGroupRequest buildWithoutInvocationCallback() {
            GetGroupRequest request = new GetGroupRequest();
            request.groupId = this.groupId;
            return request;
        }
    }
}

