/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.List;

public abstract class TemporalCalendarFieldsNode
extends JavaScriptBaseNode {
    @Node.Child
    private GetMethodNode getMethodFieldsNode = GetMethodNode.create(JavaScriptLanguage.get(null).getJSContext(), TemporalConstants.FIELDS);
    @Node.Child
    private JSFunctionCallNode callFieldsNode;

    protected TemporalCalendarFieldsNode() {
    }

    public abstract List<TruffleString> execute(JSDynamicObject var1, List<TruffleString> var2);

    @Specialization
    protected List<TruffleString> calendarFields(JSDynamicObject calendar, List<TruffleString> strings, @Cached InlinedConditionProfile fieldsUndefined) {
        Object fields = this.getMethodFieldsNode.executeWithTarget((Object)calendar);
        if (fieldsUndefined.profile((Node)this, fields == Undefined.instance)) {
            return strings;
        }
        JSDynamicObject fieldsArray = JSArray.createConstant(this.getLanguage().getJSContext(), this.getRealm(), Boundaries.listToArray(strings));
        fieldsArray = this.callFields(fields, calendar, new Object[]{fieldsArray});
        return TemporalUtil.iterableToListOfTypeString(fieldsArray);
    }

    private JSDynamicObject callFields(Object fieldsFn, JSDynamicObject calendar, Object[] args) {
        if (this.callFieldsNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callFieldsNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
        }
        return TemporalUtil.toDynamicObject(this.callFieldsNode.executeCall(JSArguments.create((Object)calendar, fieldsFn, args)));
    }
}

