/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.builtins.ArrayBufferPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.ArrayPrototypeBuiltins;
import com.oracle.truffle.js.builtins.ConstructorBuiltins;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.cast.JSToIndexNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerAsLongNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.DirectByteBufferHelper;
import java.nio.ByteBuffer;
import java.util.EnumSet;

public final class ArrayBufferPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<ArrayBufferPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new ArrayBufferPrototypeBuiltins();

    protected ArrayBufferPrototypeBuiltins() {
        super(JSArrayBuffer.PROTOTYPE_NAME, ArrayBufferPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, ArrayBufferPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 1: {
                return ArrayBufferPrototypeBuiltinsFactory.JSArrayBufferSliceNodeGen.create(context, builtin, ArrayBufferPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 0: {
                return ArrayBufferPrototypeBuiltinsFactory.ByteLengthGetterNodeGen.create(context, builtin, ArrayBufferPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 2: {
                return ArrayBufferPrototypeBuiltinsFactory.DetachedGetterNodeGen.create(context, builtin, ArrayBufferPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 3: {
                return ArrayBufferPrototypeBuiltinsFactory.JSArrayBufferTransferNodeGen.create(context, builtin, true, ArrayBufferPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 4: {
                return ArrayBufferPrototypeBuiltinsFactory.JSArrayBufferTransferNodeGen.create(context, builtin, false, ArrayBufferPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum ArrayBufferPrototype implements BuiltinEnum<ArrayBufferPrototype>
    {
        byteLength(0),
        slice(2),
        detached(0),
        transfer(0),
        transferToFixedLength(0);

        private final int length;

        private ArrayBufferPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return this == byteLength || this == detached;
        }

        @Override
        public int getECMAScriptVersion() {
            if (EnumSet.of(detached, transfer, transferToFixedLength).contains(this)) {
                return 15;
            }
            return BuiltinEnum.super.getECMAScriptVersion();
        }
    }

    @ImportStatic(value={JSArrayBuffer.class, JSConfig.class})
    public static abstract class JSArrayBufferSliceNode
    extends JSArrayBufferAbstractSliceNode {
        public JSArrayBufferSliceNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject sliceIntInt(JSArrayBufferObject.Heap thisObj, int begin, int end, @Cached @Cached.Shared(value="errorBranch") InlinedBranchProfile errorBranch) {
            this.checkDetachedBuffer(thisObj, errorBranch);
            byte[] byteArray = JSArrayBuffer.getByteArray((Object)thisObj);
            int clampedBegin = JSArrayBufferSliceNode.clampIndex(begin, 0, byteArray.length);
            int clampedEnd = JSArrayBufferSliceNode.clampIndex(end, clampedBegin, byteArray.length);
            int newLen = Math.max(clampedEnd - clampedBegin, 0);
            JSArrayBufferObject resObj = this.constructNewArrayBuffer(thisObj, newLen, false, errorBranch);
            byte[] newByteArray = JSArrayBuffer.getByteArray((Object)resObj);
            System.arraycopy(byteArray, clampedBegin, newByteArray, 0, newLen);
            return resObj;
        }

        private JSArrayBufferObject constructNewArrayBuffer(JSArrayBufferObject thisObj, int newLen, boolean direct, InlinedBranchProfile errorBranch) {
            JSFunctionObject defaultConstructor = this.getRealm().getArrayBufferConstructor();
            Object constr = this.getArraySpeciesConstructorNode().speciesConstructor(thisObj, defaultConstructor);
            Object resObj = this.getArraySpeciesConstructorNode().construct(constr, newLen);
            if (direct && !JSArrayBuffer.isJSDirectArrayBuffer(resObj) || !direct && !JSArrayBuffer.isJSHeapArrayBuffer(resObj)) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeErrorArrayBufferExpected();
            }
            JSArrayBufferObject newBuffer = (JSArrayBufferObject)((Object)resObj);
            this.checkDetachedBuffer(newBuffer, errorBranch);
            if (resObj == thisObj) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeError("SameValue(new, O) is forbidden");
            }
            if (direct && JSArrayBuffer.getDirectByteLength(resObj) < newLen || !direct && JSArrayBuffer.getHeapByteLength(resObj) < newLen) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeError("insufficient length constructed");
            }
            this.checkDetachedBuffer(thisObj, errorBranch);
            return newBuffer;
        }

        private void checkDetachedBuffer(JSArrayBufferObject arrayBuffer, InlinedBranchProfile errorBranch) {
            if (!this.getContext().getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(arrayBuffer)) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeErrorDetachedBuffer();
            }
        }

        @Specialization(replaces={"sliceIntInt"})
        protected JSDynamicObject slice(JSArrayBufferObject.Heap thisObj, Object begin0, Object end0, @Cached @Cached.Shared(value="errorBranch") InlinedBranchProfile errorBranch) {
            this.checkDetachedBuffer(thisObj, errorBranch);
            int len = JSArrayBuffer.getByteArray((Object)thisObj).length;
            int begin = this.getStart(begin0, len);
            int finalEnd = this.getEnd(end0, len);
            return this.sliceIntInt(thisObj, begin, finalEnd, errorBranch);
        }

        @Specialization
        protected JSDynamicObject sliceDirectIntInt(JSArrayBufferObject.Direct thisObj, int begin, int end, @Cached @Cached.Shared(value="errorBranch") InlinedBranchProfile errorBranch) {
            this.checkDetachedBuffer(thisObj, errorBranch);
            ByteBuffer byteBuffer = JSArrayBuffer.getDirectByteBuffer((Object)thisObj);
            int byteLength = JSArrayBuffer.getDirectByteLength((Object)thisObj);
            int clampedBegin = JSArrayBufferSliceNode.clampIndex(begin, 0, byteLength);
            int clampedEnd = JSArrayBufferSliceNode.clampIndex(end, clampedBegin, byteLength);
            int newLen = clampedEnd - clampedBegin;
            JSArrayBufferObject resObj = this.constructNewArrayBuffer(thisObj, newLen, true, errorBranch);
            ByteBuffer resBuffer = JSArrayBuffer.getDirectByteBuffer((Object)resObj);
            Boundaries.byteBufferPutSlice(resBuffer, 0, byteBuffer, clampedBegin, clampedEnd);
            return resObj;
        }

        @Specialization(replaces={"sliceDirectIntInt"})
        protected JSDynamicObject sliceDirect(JSArrayBufferObject.Direct thisObj, Object begin0, Object end0, @Cached @Cached.Shared(value="errorBranch") InlinedBranchProfile errorBranch) {
            this.checkDetachedBuffer(thisObj, errorBranch);
            int len = JSArrayBuffer.getDirectByteLength((Object)thisObj);
            int begin = this.getStart(begin0, len);
            int end = this.getEnd(end0, len);
            return this.sliceDirectIntInt(thisObj, begin, end, errorBranch);
        }

        @Specialization
        protected Object sliceInterop(JSArrayBufferObject.Interop thisObj, Object begin0, Object end0, @Cached @Cached.Shared(value="errorBranch") InlinedBranchProfile errorBranch, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared(value="srcBufferLib") InteropLibrary srcBufferLib, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared(value="dstBufferLib") InteropLibrary dstBufferLib) {
            this.checkDetachedBuffer(thisObj, errorBranch);
            Object interopBuffer = JSArrayBuffer.getInteropBuffer((Object)thisObj);
            int length = ConstructorBuiltins.ConstructArrayBufferNode.getBufferSizeSafe(interopBuffer, srcBufferLib, this, errorBranch);
            int begin = this.getStart(begin0, length);
            int end = this.getEnd(end0, length);
            int clampedBegin = JSArrayBufferSliceNode.clampIndex(begin, 0, length);
            int clampedEnd = JSArrayBufferSliceNode.clampIndex(end, clampedBegin, length);
            int newLen = Math.max(clampedEnd - clampedBegin, 0);
            JSArrayBufferObject resObj = this.constructNewArrayBuffer(thisObj, newLen, this.getContext().isOptionDirectByteBuffer(), errorBranch);
            this.copyInteropBufferElements((Object)thisObj, (Object)resObj, clampedBegin, newLen, errorBranch, srcBufferLib, dstBufferLib);
            return resObj;
        }

        private void copyInteropBufferElements(Object srcBuffer, Object dstBuffer, int srcBufferOffset, int len, InlinedBranchProfile errorBranch, InteropLibrary srcBufferLib, InteropLibrary dstBufferLib) {
            try {
                for (int i = 0; i < len; ++i) {
                    dstBufferLib.writeBufferByte(dstBuffer, (long)i, srcBufferLib.readBufferByte(srcBuffer, (long)(srcBufferOffset + i)));
                }
            }
            catch (InvalidBufferOffsetException | UnsupportedMessageException e) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeErrorInteropException(dstBuffer, (InteropException)e, "buffer access", null);
            }
        }

        @Specialization(guards={"!isJSSharedArrayBuffer(thisObj)", "hasBufferElements(thisObj, srcBufferLib)"})
        protected Object sliceTruffleBuffer(Object thisObj, Object begin0, Object end0, @Cached @Cached.Shared(value="errorBranch") InlinedBranchProfile errorBranch, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared(value="srcBufferLib") InteropLibrary srcBufferLib, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared(value="dstBufferLib") InteropLibrary dstBufferLib) {
            return this.sliceInterop(JSArrayBuffer.createInteropArrayBuffer(this.getContext(), this.getRealm(), thisObj), begin0, end0, errorBranch, srcBufferLib, dstBufferLib);
        }

        @Fallback
        protected static JSDynamicObject error(Object thisObj, Object begin0, Object end0) {
            throw Errors.createTypeErrorIncompatibleReceiver(thisObj);
        }

        static boolean hasBufferElements(Object buffer, InteropLibrary interop) {
            return interop.hasBufferElements(buffer);
        }
    }

    @ImportStatic(value={JSArrayBuffer.class, JSConfig.class})
    public static abstract class ByteLengthGetterNode
    extends JSBuiltinNode {
        public ByteLengthGetterNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSHeapArrayBuffer(thisObj)"})
        protected int heapArrayBuffer(Object thisObj) {
            byte[] byteArray = JSArrayBuffer.getByteArray(thisObj);
            if (!this.getContext().getTypedArrayNotDetachedAssumption().isValid() && byteArray == null) {
                return 0;
            }
            return byteArray.length;
        }

        @Specialization(guards={"isJSDirectArrayBuffer(thisObj)"})
        protected int directArrayBuffer(Object thisObj) {
            ByteBuffer byteBuffer = JSArrayBuffer.getDirectByteBuffer(thisObj);
            if (!this.getContext().getTypedArrayNotDetachedAssumption().isValid() && byteBuffer == null) {
                return 0;
            }
            return byteBuffer.capacity();
        }

        @Specialization(guards={"isJSInteropArrayBuffer(thisObj)"})
        protected int interopArrayBuffer(Object thisObj, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop) {
            Object buffer = JSArrayBuffer.getInteropBuffer(thisObj);
            if (!this.getContext().getTypedArrayNotDetachedAssumption().isValid() && buffer == null) {
                return 0;
            }
            try {
                long bufferSize = interop.getBufferSize(buffer);
                assert (JSRuntime.longIsRepresentableAsInt(bufferSize));
                return (int)bufferSize;
            }
            catch (UnsupportedMessageException e) {
                return 0;
            }
        }

        @Fallback
        protected static int error(Object thisObj) {
            throw Errors.createTypeErrorArrayBufferExpected();
        }
    }

    public static abstract class DetachedGetterNode
    extends JSBuiltinNode {
        public DetachedGetterNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"!isJSSharedArrayBuffer(arrayBuffer)"})
        protected boolean detached(JSArrayBufferObject arrayBuffer) {
            if (this.getContext().getTypedArrayNotDetachedAssumption().isValid()) {
                return false;
            }
            return arrayBuffer.isDetached();
        }

        @Fallback
        protected static boolean error(Object thisObj) {
            throw Errors.createTypeErrorArrayBufferExpected();
        }
    }

    public static abstract class JSArrayBufferTransferNode
    extends JSBuiltinNode {
        private final boolean preserveResizability;

        public JSArrayBufferTransferNode(JSContext context, JSBuiltin builtin, boolean preserveResizability) {
            super(context, builtin);
            this.preserveResizability = preserveResizability;
        }

        @Specialization(guards={"!isJSSharedArrayBuffer(arrayBuffer)"})
        protected Object transfer(JSArrayBufferObject arrayBuffer, Object newLength, @Cached JSToIndexNode toIndexNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedBranchProfile differentByteLengthBranch, @Cached InlinedConditionProfile heapBufferProfile, @Cached InlinedConditionProfile directBufferProfile) {
            JSArrayBufferObject newBuffer;
            int newByteLength = 0;
            if (newLength != Undefined.instance) {
                long byteLength = toIndexNode.executeLong(newLength);
                if (byteLength > (long)this.getContext().getLanguageOptions().maxTypedArrayLength()) {
                    errorBranch.enter((Node)this);
                    throw Errors.createRangeErrorInvalidBufferSize();
                }
                newByteLength = (int)byteLength;
            }
            if (!this.getContext().getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(arrayBuffer)) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeErrorDetachedBuffer();
            }
            int oldByteLength = this.getByteLength(arrayBuffer, heapBufferProfile, directBufferProfile);
            if (newLength == Undefined.instance) {
                newByteLength = oldByteLength;
            }
            if (this.preserveResizability && arrayBuffer.isResizable()) {
                int newMaxByteLength = arrayBuffer.getMaxByteLength();
            } else {
                int newMaxByteLength = -1;
            }
            if (arrayBuffer.getDetachKey() != Undefined.instance) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeErrorInvalidDetachKey();
            }
            boolean sameByteLength = newByteLength == oldByteLength;
            int copyLength = Math.min(newByteLength, oldByteLength);
            JSContext context = this.getContext();
            JSRealm realm = this.getRealm();
            if (heapBufferProfile.profile((Node)this, JSArrayBuffer.isJSHeapArrayBuffer((Object)arrayBuffer))) {
                JSArrayBufferObject.Heap heapArrayBuffer = (JSArrayBufferObject.Heap)arrayBuffer;
                byte[] array = heapArrayBuffer.getByteArray();
                if (!sameByteLength) {
                    differentByteLengthBranch.enter((Node)this);
                    byte[] newArray = new byte[newByteLength];
                    System.arraycopy(array, 0, newArray, 0, copyLength);
                    array = newArray;
                }
                newBuffer = JSArrayBuffer.createArrayBuffer(context, realm, array);
            } else if (directBufferProfile.profile((Node)this, JSArrayBuffer.isJSDirectArrayBuffer((Object)arrayBuffer))) {
                JSArrayBufferObject.Direct directArrayBuffer = (JSArrayBufferObject.Direct)arrayBuffer;
                ByteBuffer byteBuffer = directArrayBuffer.getByteBuffer();
                if (!sameByteLength) {
                    differentByteLengthBranch.enter((Node)this);
                    ByteBuffer newByteBuffer = DirectByteBufferHelper.allocateDirect(newByteLength);
                    Boundaries.byteBufferPutSlice(newByteBuffer, 0, byteBuffer, 0, copyLength);
                    byteBuffer = newByteBuffer;
                }
                newBuffer = JSArrayBuffer.createDirectArrayBuffer(context, realm, byteBuffer);
            } else {
                assert (JSArrayBuffer.isJSInteropArrayBuffer((Object)arrayBuffer));
                throw Errors.createTypeError("Cannot transfer an interop ArrayBuffer");
            }
            JSArrayBuffer.detachArrayBuffer(arrayBuffer);
            return newBuffer;
        }

        private int getByteLength(JSArrayBufferObject arrayBuffer, InlinedConditionProfile heapBufferProfile, InlinedConditionProfile directBufferProfile) {
            if (heapBufferProfile.profile((Node)this, JSArrayBuffer.isJSHeapArrayBuffer((Object)arrayBuffer))) {
                return JSArrayBuffer.getHeapByteLength((Object)arrayBuffer);
            }
            if (directBufferProfile.profile((Node)this, JSArrayBuffer.isJSDirectArrayBuffer((Object)arrayBuffer))) {
                return JSArrayBuffer.getDirectByteLength((Object)arrayBuffer);
            }
            return ((JSArrayBufferObject.Interop)arrayBuffer).getByteLength();
        }

        @Fallback
        protected static Object error(Object thisObj, Object newLength) {
            throw Errors.createTypeErrorArrayBufferExpected();
        }
    }

    public static abstract class JSArrayBufferAbstractSliceNode
    extends JSArrayBufferOperation {
        @Node.Child
        private ArrayPrototypeBuiltins.ArraySpeciesConstructorNode arraySpeciesCreateNode;

        public JSArrayBufferAbstractSliceNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected int getStart(Object start, int len) {
            long relativeStart = this.toInteger(start);
            if (relativeStart < 0L) {
                return (int)Math.max((long)len + relativeStart, 0L);
            }
            return (int)Math.min(relativeStart, (long)len);
        }

        protected int getEnd(Object end, int len) {
            long relativeEnd;
            long l = relativeEnd = end == Undefined.instance ? (long)len : this.toInteger(end);
            if (relativeEnd < 0L) {
                return (int)Math.max((long)len + relativeEnd, 0L);
            }
            return (int)Math.min(relativeEnd, (long)len);
        }

        protected static int clampIndex(int index, int lowerBound, int upperBound) {
            return JSArrayBufferAbstractSliceNode.clamp(index >= 0 ? index : index + upperBound, lowerBound, upperBound);
        }

        private static int clamp(int index, int lowerBound, int upperBound) {
            return Math.max(Math.min(index, upperBound), lowerBound);
        }

        public ArrayPrototypeBuiltins.ArraySpeciesConstructorNode getArraySpeciesConstructorNode() {
            if (this.arraySpeciesCreateNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.arraySpeciesCreateNode = (ArrayPrototypeBuiltins.ArraySpeciesConstructorNode)this.insert(ArrayPrototypeBuiltins.ArraySpeciesConstructorNode.create(this.getContext(), true));
            }
            return this.arraySpeciesCreateNode;
        }
    }

    public static abstract class JSArrayBufferOperation
    extends JSBuiltinNode {
        @Node.Child
        private JSToIntegerAsLongNode toIntegerNode;

        public JSArrayBufferOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected long toInteger(Object thisObject) {
            if (this.toIntegerNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toIntegerNode = (JSToIntegerAsLongNode)this.insert(JSToIntegerAsLongNode.create());
            }
            return this.toIntegerNode.executeLong(thisObject);
        }
    }
}

