/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.transfer;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.project.connections.RemoteClientImplementation;
import org.netbeans.modules.php.project.connections.transfer.TransferFile;

public final class LocalTransferFile
extends TransferFile {
    private static final Logger LOGGER = Logger.getLogger(LocalTransferFile.class.getName());
    private final File file;
    private final boolean forceDirectory;
    private volatile Boolean isFile = null;
    private volatile Boolean isDirectory = null;

    LocalTransferFile(RemoteClientImplementation remoteClient, File file, TransferFile parent, boolean forceDirectory) {
        super(remoteClient, parent);
        this.file = file;
        this.forceDirectory = forceDirectory;
        if (file == null) {
            throw new NullPointerException("Local file cannot be null");
        }
        String baseLocalDirectory = remoteClient.getBaseLocalDirectory();
        if (!file.getAbsolutePath().startsWith(baseLocalDirectory)) {
            throw new IllegalArgumentException("File '" + file.getAbsolutePath() + "' must be underneath base directory '" + baseLocalDirectory + "'");
        }
        if (forceDirectory && file.isFile()) {
            throw new IllegalArgumentException("File '" + file.getAbsolutePath() + "' can't be forced as a directory since it is a file");
        }
        this.getSize();
        this.getTimestamp();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getRemotePath() {
        String absolutePath = this.file.getAbsolutePath();
        if (absolutePath.equals(this.remoteClient.getBaseLocalDirectory())) {
            return ".";
        }
        String remotePath = absolutePath.substring(this.remoteClient.getBaseLocalDirectory().length() + File.separator.length());
        if (File.separator.equals("/")) {
            return remotePath;
        }
        return remotePath.replace(File.separator, "/");
    }

    @Override
    protected long getSizeImpl() {
        if (this.isFile()) {
            return this.file.length();
        }
        return 0L;
    }

    @Override
    public boolean isDirectory() {
        if (this.isDirectory != null) {
            return this.isDirectory;
        }
        if (this.file.exists()) {
            this.isDirectory = this.file.isDirectory();
            if (this.forceDirectory && !this.isDirectory.booleanValue() && this.file.isFile()) assert (false) : "File forced as directory but is regular existing file";
            return this.isDirectory;
        }
        this.isDirectory = this.forceDirectory;
        return this.isDirectory;
    }

    @Override
    public boolean isFile() {
        if (this.isFile != null) {
            return this.isFile;
        }
        if (this.file.exists()) {
            this.isFile = this.file.isFile();
            if (this.isFile.booleanValue() && this.forceDirectory) assert (false) : "File forced as directory but is regular existing file";
            return this.isFile;
        }
        this.isFile = !this.forceDirectory;
        return this.isFile;
    }

    @Override
    public boolean isLink() {
        return FileUtils.isDirectoryLink((File)this.file);
    }

    @Override
    protected long getTimestampImpl() {
        return TimeUnit.SECONDS.convert(this.file.lastModified(), TimeUnit.MILLISECONDS);
    }
}

