/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings.refactoring.tree;

import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.lsp.client.bindings.refactoring.tree.FileTreeElement;
import org.netbeans.modules.lsp.client.bindings.refactoring.tree.ProjectTreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactoryImplementation;
import org.openide.filesystems.FileObject;

public class TreeElementFactoryImpl
implements TreeElementFactoryImplementation {
    private final Map<Object, TreeElement> map = new WeakHashMap<Object, TreeElement>();

    public TreeElement getTreeElement(Object o) {
        TreeElement result = this.map.get(o);
        if (result != null) {
            return result;
        }
        if (o instanceof FileObject) {
            result = new FileTreeElement((FileObject)o);
        } else if (o instanceof Project) {
            result = new ProjectTreeElement((Project)o);
        }
        if (result != null) {
            if (o instanceof SourceGroup) {
                this.map.put(((SourceGroup)o).getRootFolder(), result);
            } else {
                this.map.put(o, result);
            }
        }
        return result;
    }

    public void cleanUp() {
        this.map.clear();
    }
}

