/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.textile.core.block;

import org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public class NotextileTagBlock
extends Block {
    private static final String NOTEXTILE_OPEN_TAG = "<notextile>";
    private static final String NOTEXTILE_CLOSE_TAG = "</notextile>";
    private int blockLineCount = 0;

    protected int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            offset += NOTEXTILE_OPEN_TAG.length();
        }
        ++this.blockLineCount;
        if (offset >= line.length()) {
            if (this.blockLineCount > 1) {
                this.builder.characters("\n");
            }
            return -1;
        }
        int indexOfCloseTag = line.indexOf(NOTEXTILE_CLOSE_TAG, offset);
        if (indexOfCloseTag >= 0) {
            this.builder.charactersUnescaped(line.substring(offset, indexOfCloseTag));
            this.setClosed(true);
            return indexOfCloseTag + NOTEXTILE_CLOSE_TAG.length();
        }
        this.builder.charactersUnescaped(line.substring(offset));
        if (this.blockLineCount > 1) {
            this.builder.characters("\n");
        }
        return -1;
    }

    public boolean canStart(String line, int lineOffset) {
        return line.substring(lineOffset).startsWith(NOTEXTILE_OPEN_TAG);
    }
}

