/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.librarydescriptor;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryChooser;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.librarydescriptor.NewLibraryDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class SelectLibraryPanel
extends BasicWizardIterator.Panel {
    private NewLibraryDescriptor.DataModel data;
    private final LibraryChooser.Panel panel;

    public SelectLibraryPanel(WizardDescriptor setting, NewLibraryDescriptor.DataModel data) {
        super(setting);
        this.data = data;
        this.getAccessibleContext().setAccessibleDescription(SelectLibraryPanel.getMessage("ACS_SelectLibraryPanel"));
        this.putClientProperty("NewFileWizard_Title", SelectLibraryPanel.getMessage("LBL_LibraryWizardTitle"));
        this.panel = LibraryChooser.createPanel(null, null);
        this.panel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedLibraries".equals(evt.getPropertyName())) {
                    SelectLibraryPanel.this.checkValidity();
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add(this.panel.getVisualComponent(), "Center");
    }

    private void checkValidity() {
        if (this.getSelectedLibrary() != null) {
            this.markValid();
        } else {
            this.markInvalid();
        }
    }

    private Library getSelectedLibrary() {
        Set selection = this.panel.getSelectedLibraries();
        return selection.size() == 1 ? (Library)selection.iterator().next() : null;
    }

    @Override
    protected void storeToDataModel() {
        this.data.setLibrary(this.getSelectedLibrary());
    }

    @Override
    protected void readFromDataModel() {
        this.checkValidity();
    }

    @Override
    protected String getPanelName() {
        return SelectLibraryPanel.getMessage("LBL_SelectLibraryPanel_Title");
    }

    @Override
    protected HelpCtx getHelp() {
        return new HelpCtx(SelectLibraryPanel.class);
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(SelectLibraryPanel.class, (String)key);
    }
}

