/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen.model;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.codegen.model.EntityClassInfo;
import org.netbeans.modules.websvc.rest.codegen.model.EntityResourceBeanModel;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.openide.util.Exceptions;

public class EntityResourceModelBuilder {
    private Map<String, EntityClassInfo> entitiesInRelationMap = new HashMap<String, EntityClassInfo>();
    private Map<String, EntityClassInfo> allEntitiesClassInfoMap = new HashMap<String, EntityClassInfo>();
    private EntityResourceBeanModel model;

    public EntityResourceModelBuilder(Project project, Collection<String> entities) {
        for (String entity : entities) {
            try {
                EntityClassInfo info = null;
                ElementHandle<TypeElement> handle = SourceGroupSupport.getHandleClassName(entity, project);
                if (handle != null) {
                    info = new EntityClassInfo(entity, handle, project, this);
                }
                if (info == null) continue;
                this.allEntitiesClassInfoMap.put(entity, info);
                if (info.getFieldInfos().isEmpty()) continue;
                this.entitiesInRelationMap.put(entity, info);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }

    public Set<EntityClassInfo> getEntityInfos() {
        return new HashSet<EntityClassInfo>(this.allEntitiesClassInfoMap.values());
    }

    public Set<String> getAllEntityNames() {
        return this.allEntitiesClassInfoMap.keySet();
    }

    public EntityClassInfo getEntityClassInfo(String type) {
        return this.allEntitiesClassInfoMap.get(type);
    }

    public EntityResourceBeanModel build() {
        this.model = new EntityResourceBeanModel(this);
        try {
            for (Map.Entry<String, EntityClassInfo> entry : this.entitiesInRelationMap.entrySet()) {
                String fqn = entry.getKey();
                EntityClassInfo info = entry.getValue();
                this.model.addEntityInfo(fqn, info);
                this.computeRelationships(info);
            }
            this.model.setValid(true);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            this.model.setValid(false);
        }
        this.entitiesInRelationMap.clear();
        return this.model;
    }

    private void computeRelationships(EntityClassInfo info) {
        for (EntityClassInfo.FieldInfo fieldInfo : info.getFieldInfos()) {
            EntityClassInfo classInfo;
            if (!fieldInfo.isRelationship()) continue;
            if (fieldInfo.isOneToMany() || fieldInfo.isManyToMany()) {
                String typeArg = fieldInfo.getTypeArg();
                classInfo = this.allEntitiesClassInfoMap.get(typeArg);
                this.model.addEntityInfo(typeArg, classInfo);
                continue;
            }
            String type = fieldInfo.getType();
            classInfo = this.allEntitiesClassInfoMap.get(type);
            this.model.addEntityInfo(type, classInfo);
        }
    }
}

