/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.ast;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.netbeans.modules.languages.hcl.ast.HCLContainer;
import org.netbeans.modules.languages.hcl.ast.HCLElement;
import org.netbeans.modules.languages.hcl.ast.HCLIdentifier;

public final class HCLBlock
extends HCLContainer {
    private final String id;
    private final List<HCLIdentifier> declaration;

    public HCLBlock(List<HCLIdentifier> declaration, List<HCLElement> elements) {
        super(elements);
        Objects.requireNonNull(declaration, "declaration cannot be null");
        if (declaration.isEmpty()) {
            throw new IllegalArgumentException("declaration cannot be empty");
        }
        this.declaration = List.copyOf(declaration);
        this.id = declaration.stream().map(d -> d.id()).collect(Collectors.joining("."));
    }

    public List<HCLIdentifier> declaration() {
        return this.declaration;
    }

    public String id() {
        return this.id;
    }

    public String toString() {
        return "HCLBlock[declaration=" + this.declaration + ", elements=" + this.elements + "]";
    }

    public boolean equals(Object obj) {
        boolean bl;
        if (obj instanceof HCLBlock) {
            HCLBlock that = (HCLBlock)obj;
            bl = Objects.equals(this.declaration, that.declaration) && Objects.equals(this.elements, that.elements);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return Objects.hash(this.declaration, this.elements);
    }
}

