/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.j2ee.ddloaders.multiview.InnerTableModel;
import org.netbeans.modules.j2ee.ddloaders.multiview.Utils;
import org.netbeans.modules.xml.multiview.ui.DefaultTablePanel;
import org.netbeans.modules.xml.multiview.ui.SectionNodeInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionNodeView;
import org.openide.util.NbBundle;

public class InnerTablePanel
extends SectionNodeInnerPanel {
    private final TablePanel tablePanel;
    private JTable table;

    protected void setButtonListeners(final InnerTableModel model) {
        final JTable table = this.getTable();
        this.getAddButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InnerTablePanel.this.stopCellEditing(table);
                InnerTablePanel.this.selectCell(model.addRow(), 0);
                model.modelUpdatedFromUI();
                org.netbeans.modules.xml.multiview.Utils.scrollToVisible((JComponent)((Object)InnerTablePanel.this.tablePanel));
            }
        });
        this.getEditButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InnerTablePanel.this.editCell(table.getSelectedRow(), table.getSelectedColumn());
            }
        });
        this.getRemoveButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int column;
                int row = table.getSelectedRow();
                TableCellEditor cellEditor = table.getCellEditor(row, column = table.getSelectedColumn());
                if (cellEditor != null) {
                    cellEditor.cancelCellEditing();
                }
                int rowCount = model.getRowCount() - 1;
                model.removeRow(row);
                model.modelUpdatedFromUI();
                if (row >= rowCount) {
                    row = rowCount - 1;
                }
                if (row >= 0) {
                    final int n = row;
                    Utils.runInAwtDispatchThread(new Runnable(){

                        @Override
                        public void run() {
                            InnerTablePanel.this.selectCell(n, column);
                        }
                    });
                }
            }
        });
    }

    private void stopCellEditing(JTable table) {
        table.editCellAt(-1, -1);
    }

    public InnerTablePanel(SectionNodeView sectionNodeView, InnerTableModel model) {
        super(sectionNodeView);
        this.tablePanel = new TablePanel(model);
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int type = e.getType();
                if (type == 1 || type == -1) {
                    InnerTablePanel.this.scheduleRefreshView();
                }
            }
        });
        this.table = this.tablePanel.getTable();
        this.table.setSelectionMode(0);
        this.table.setRowSelectionAllowed(true);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    InnerTablePanel.this.editCell(InnerTablePanel.this.table.getSelectedRow(), InnerTablePanel.this.table.getSelectedColumn());
                }
            }
        });
        InputMap inputMap = this.table.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "selectNextColumnCell");
        inputMap.put(KeyStroke.getKeyStroke("shift ENTER"), "selectPreviousColumnCell");
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InnerTablePanel.class, (String)"ACSN_Table"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InnerTablePanel.class, (String)"ACSD_Table"));
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.tablePanel), "West");
        this.setColumnWidths();
        this.setButtonListeners(model);
        this.setColumnEditors(model);
        this.scheduleRefreshView();
        TableColumnModel columnModel = this.table.getColumnModel();
        int n = columnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableCellEditor tableCellEditor = model.getTableCellEditor(i);
            if (tableCellEditor == null) continue;
            columnModel.getColumn(i).setCellEditor(tableCellEditor);
        }
    }

    private void setColumnEditors(InnerTableModel model) {
        TableColumnModel columnModel = this.table.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableCellEditor cellEditor = model.getCellEditor(i);
            if (cellEditor == null) continue;
            columnModel.getColumn(i).setCellEditor(cellEditor);
        }
    }

    public JTable getTable() {
        return this.table;
    }

    public JButton getAddButton() {
        return this.tablePanel.getAddButton();
    }

    public JButton getEditButton() {
        return this.tablePanel.getEditButton();
    }

    public JButton getRemoveButton() {
        return this.tablePanel.getRemoveButton();
    }

    public void setColumnWidths() {
        JTable table = this.tablePanel.getTable();
        InnerTableModel tableModel = (InnerTableModel)table.getModel();
        TableColumnModel columnModel = table.getColumnModel();
        int n = columnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            int width = tableModel.getDefaultColumnWidth(i);
            TableColumn column = columnModel.getColumn(i);
            column.setPreferredWidth(width);
            column.setWidth(width);
        }
    }

    protected void editCell(final int row, final int column) {
        if (this.table.isCellEditable(row, column)) {
            this.selectCell(row, column);
            Utils.runInAwtDispatchThread(new Runnable(){

                @Override
                public void run() {
                    JTable table = InnerTablePanel.this.getTable();
                    table.editCellAt(row, column);
                    Component editorComponent = table.getEditorComponent();
                    editorComponent.requestFocus();
                }
            });
        }
    }

    private void selectCell(final int row, final int column) {
        Utils.runInAwtDispatchThread(new Runnable(){

            @Override
            public void run() {
                JTable table = InnerTablePanel.this.getTable();
                table.getSelectionModel().setLeadSelectionIndex(row);
                table.getColumnModel().getSelectionModel().setLeadSelectionIndex(column);
                table.requestFocus();
            }
        });
    }

    public JComponent getErrorComponent(String errorId) {
        return null;
    }

    public void setValue(JComponent source, Object value) {
    }

    public void dataModelPropertyChange(Object source, String propertyName, Object oldValue, Object newValue) {
        ((InnerTableModel)this.getTable().getModel()).tableChanged();
        this.scheduleRefreshView();
    }

    public void linkButtonPressed(Object ddBean, String ddProperty) {
    }

    private class TablePanel
    extends DefaultTablePanel {
        public TablePanel(AbstractTableModel model) {
            super(model);
            final JTable table = this.getTable();
            table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int selectedRowCount = table.getSelectedRowCount();
                    TablePanel.this.removeButton.setEnabled(selectedRowCount > 0);
                    TablePanel.this.editButton.setEnabled(selectedRowCount == 1);
                }
            });
        }

        public JButton getAddButton() {
            return this.addButton;
        }

        public JButton getEditButton() {
            return this.editButton;
        }

        public JButton getRemoveButton() {
            return this.removeButton;
        }
    }
}

