/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.classpath;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ClassPathSupportCallbackImpl
implements ClassPathSupport.Callback {
    private AntProjectHelper helper;
    private static final String TAG_PATH_IN_EAR = "path-in-war";
    private static final String TAG_FILE = "file";
    private static final String TAG_LIBRARY = "library";
    private static final String ATTR_FILES = "files";
    private static final String ATTR_DIRS = "dirs";
    public static final String PATH_IN_DEPLOYMENT = "pathInDeployment";

    public ClassPathSupportCallbackImpl(AntProjectHelper helper) {
        this.helper = helper;
    }

    public void readAdditionalProperties(List<ClassPathSupport.Item> items, String projectXMLElement) {
        Map<String, String> earIncludesMap = this.createEarIncludesMap(projectXMLElement);
        for (ClassPathSupport.Item item : items) {
            String deploymentPath = earIncludesMap.get(item.getReference());
            item.setAdditionalProperty(PATH_IN_DEPLOYMENT, deploymentPath);
        }
    }

    public void storeAdditionalProperties(List<ClassPathSupport.Item> items, String projectXMLElement) {
        ClassPathSupportCallbackImpl.writeWebLibraries(items, this.helper, projectXMLElement);
    }

    private static void writeWebLibraries(List<ClassPathSupport.Item> classpath, AntProjectHelper helper, String elementName) {
        Element data = helper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element webModuleLibs = (Element)data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-earproject/2", elementName).item(0);
        if (webModuleLibs == null) {
            webModuleLibs = doc.createElementNS("http://www.netbeans.org/ns/j2ee-earproject/2", elementName);
            data.appendChild(webModuleLibs);
        }
        while (webModuleLibs.hasChildNodes()) {
            webModuleLibs.removeChild(webModuleLibs.getChildNodes().item(0));
        }
        for (ClassPathSupport.Item item : classpath) {
            Element library = doc.createElementNS("http://www.netbeans.org/ns/j2ee-earproject/2", TAG_LIBRARY);
            webModuleLibs.appendChild(library);
            Element webFile = doc.createElementNS("http://www.netbeans.org/ns/j2ee-earproject/2", TAG_FILE);
            library.appendChild(webFile);
            String pathItem = CommonProjectUtils.getAntPropertyName((String)item.getReference());
            webFile.appendChild(doc.createTextNode("${" + pathItem + "}"));
            String piw = item.getAdditionalProperty(PATH_IN_DEPLOYMENT);
            if (piw == null) continue;
            Element pathInEar = doc.createElementNS("http://www.netbeans.org/ns/j2ee-earproject/2", TAG_PATH_IN_EAR);
            pathInEar.appendChild(doc.createTextNode(piw));
            library.appendChild(pathInEar);
        }
        helper.putPrimaryConfigurationData(data, true);
    }

    private Map<String, String> createEarIncludesMap(String webLibraryElementName) {
        LinkedHashMap<String, String> earIncludesMap = new LinkedHashMap<String, String>();
        if (webLibraryElementName != null) {
            Element data = this.helper.getPrimaryConfigurationData(true);
            String ns = "http://www.netbeans.org/ns/j2ee-earproject/2";
            Element webModuleLibs = (Element)data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-earproject/2", webLibraryElementName).item(0);
            if (webModuleLibs != null) {
                NodeList ch = webModuleLibs.getChildNodes();
                for (int i = 0; i < ch.getLength(); ++i) {
                    if (ch.item(i).getNodeType() != 1) continue;
                    Element library = (Element)ch.item(i);
                    Node webFile = library.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-earproject/2", TAG_FILE).item(0);
                    NodeList pathInEarElements = library.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-earproject/2", TAG_PATH_IN_EAR);
                    earIncludesMap.put(XMLUtil.findText((Node)webFile), pathInEarElements.getLength() > 0 ? XMLUtil.findText((Node)pathInEarElements.item(0)) : null);
                }
            }
        }
        return earIncludesMap;
    }
}

