/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ParseUtils {
    public static final String EXCEPTION_PREFIX = "version:";
    private static final Logger LOGGER = Logger.getLogger(ParseUtils.class.getName());

    public static String getVersion(InputStream is, DefaultHandler versionHandler, EntityResolver ddResolver) throws IOException, SAXException {
        XMLReader reader = XMLUtil.createXMLReader((boolean)false);
        reader.setContentHandler(versionHandler);
        reader.setEntityResolver(ddResolver);
        try {
            reader.parse(new InputSource(is));
        }
        catch (SAXException ex) {
            is.close();
            String message = ex.getMessage();
            if (message != null && message.startsWith(EXCEPTION_PREFIX)) {
                String versionStr = message.substring(EXCEPTION_PREFIX.length());
                if ("".equals(versionStr) || "null".equals(versionStr)) {
                    return null;
                }
                return versionStr;
            }
            throw new SAXException(NbBundle.getMessage(ParseUtils.class, (String)"MSG_cannotParse"), ex);
        }
        is.close();
        throw new SAXException(NbBundle.getMessage(ParseUtils.class, (String)"MSG_cannotFindRoot"));
    }

    public static String getVersion(InputSource is, DefaultHandler versionHandler, EntityResolver ddResolver) throws IOException, SAXException {
        XMLReader reader = XMLUtil.createXMLReader((boolean)false);
        reader.setContentHandler(versionHandler);
        reader.setEntityResolver(ddResolver);
        try {
            reader.parse(is);
        }
        catch (SAXException ex) {
            String message = ex.getMessage();
            if (message != null && message.startsWith(EXCEPTION_PREFIX)) {
                return message.substring(EXCEPTION_PREFIX.length());
            }
            throw new SAXException(NbBundle.getMessage(ParseUtils.class, (String)"MSG_cannotParse"), ex);
        }
        throw new SAXException(NbBundle.getMessage(ParseUtils.class, (String)"MSG_cannotFindRoot"));
    }

    public static SAXParseException parseDD(InputSource is, EntityResolver ddResolver) throws SAXException, IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Parsing with ddResolver: {0}", ddResolver);
        }
        ErrorHandler errorHandler = new ErrorHandler();
        try {
            XMLReader reader = XMLUtil.createXMLReader();
            reader.setErrorHandler(errorHandler);
            reader.setEntityResolver(ddResolver);
            reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            reader.setFeature("http://xml.org/sax/features/validation", true);
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            reader.parse(is);
            SAXParseException error = errorHandler.getError();
            if (error != null) {
                return error;
            }
        }
        catch (IllegalArgumentException ex) {
            SAXException sax = new SAXException(ex.getMessage(), ex);
            sax.initCause(ex);
            throw sax;
        }
        return null;
    }

    private static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        private int errorType = -1;
        SAXParseException error;

        private ErrorHandler() {
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.printMsg("warning", sAXParseException);
            if (this.errorType < 0) {
                this.errorType = 0;
                this.error = sAXParseException;
            }
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            this.printMsg("error", sAXParseException);
            if (this.errorType < 1) {
                this.errorType = 1;
                this.error = sAXParseException;
            }
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.printMsg("fatal error", sAXParseException);
            this.errorType = 2;
            throw sAXParseException;
        }

        private void printMsg(String type, SAXParseException e) {
            System.out.println("&&& SAX " + type + ": [" + e.getLineNumber() + ":" + e.getColumnNumber() + "] " + e.getPublicId() + " / " + e.getSystemId() + " / " + e);
        }

        public int getErrorType() {
            return this.errorType;
        }

        public SAXParseException getError() {
            return this.error;
        }
    }
}

