/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import com.sun.jdi.AbsentInformationException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.MethodBreakpointPanel;
import org.netbeans.modules.debugger.jpda.ui.debugging.JPDADVThread;
import org.netbeans.modules.debugger.jpda.ui.debugging.JPDADVThreadGroup;
import org.netbeans.modules.debugger.jpda.ui.models.Bundle;
import org.netbeans.modules.debugger.jpda.ui.models.CallStackActionsProvider;
import org.netbeans.modules.debugger.jpda.ui.models.DebuggingNodeModel;
import org.netbeans.modules.debugger.jpda.ui.models.MonitorModel;
import org.netbeans.modules.debugger.jpda.ui.models.ThreadsActionsProvider;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

public class DebuggingActionsProvider
implements NodeActionsProvider {
    private JPDADebugger debugger;
    private Session session;
    private RequestProcessor requestProcessor;
    private final Action POP_TO_HERE_ACTION;
    private final Action MAKE_CURRENT_ACTION;
    private final Action SUSPEND_ACTION;
    private final Action RESUME_ACTION;
    private final Action INTERRUPT_ACTION;
    private final Action COPY_TO_CLBD_ACTION;
    private final Action LANGUAGE_SELECTION;
    private final Action GO_TO_SOURCE_ACTION;
    private final Action ADD_BREAKPOINT_ACTION;

    public DebuggingActionsProvider(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.session = (Session)lookupProvider.lookupFirst(null, Session.class);
        this.requestProcessor = (RequestProcessor)lookupProvider.lookupFirst(null, RequestProcessor.class);
        this.MAKE_CURRENT_ACTION = this.createMAKE_CURRENT_ACTION(this.requestProcessor);
        this.SUSPEND_ACTION = this.createSUSPEND_ACTION(this.requestProcessor);
        this.RESUME_ACTION = this.createRESUME_ACTION(this.requestProcessor);
        this.INTERRUPT_ACTION = this.createINTERRUPT_ACTION(this.requestProcessor);
        this.COPY_TO_CLBD_ACTION = this.createCOPY_TO_CLBD_ACTION(this.requestProcessor);
        this.POP_TO_HERE_ACTION = DebuggingActionsProvider.createPOP_TO_HERE_ACTION(this.requestProcessor);
        this.LANGUAGE_SELECTION = new LanguageSelection(this.session);
        this.GO_TO_SOURCE_ACTION = DebuggingActionsProvider.createGO_TO_SOURCE_ACTION(this.requestProcessor);
        this.ADD_BREAKPOINT_ACTION = DebuggingActionsProvider.createBREAKPOINT(this.requestProcessor);
    }

    private Action createMAKE_CURRENT_ACTION(RequestProcessor requestProcessor) {
        return Models.createAction((String)NbBundle.getBundle(DebuggingActionsProvider.class).getString("CTL_ThreadAction_MakeCurrent_Label"), (Models.ActionPerformer)new LazyActionPerformer(requestProcessor){

            @Override
            public boolean isEnabled(Object node) {
                if (node instanceof JPDADVThread) {
                    return DebuggingActionsProvider.this.debugger.getCurrentThread() != ((JPDADVThread)node).getKey();
                }
                if (node instanceof CallStackFrame) {
                    CallStackFrame f = (CallStackFrame)node;
                    return !((JPDAThreadImpl)f.getThread()).isMethodInvoking() && !f.equals(DebuggingActionsProvider.this.debugger.getCurrentCallStackFrame());
                }
                return false;
            }

            @Override
            public void run(Object[] nodes) {
                if (nodes.length == 0) {
                    return;
                }
                if (nodes[0] instanceof JPDADVThread) {
                    ((JPDADVThread)nodes[0]).makeCurrent();
                    DebuggingActionsProvider.goToSource((JPDADVThread)nodes[0]);
                }
                if (nodes[0] instanceof CallStackFrame) {
                    CallStackFrame f = (CallStackFrame)nodes[0];
                    JPDAThread thread = f.getThread();
                    if (DebuggingActionsProvider.this.debugger.getCurrentThread() != thread) {
                        thread.makeCurrent();
                    }
                    f.makeCurrent();
                    DebuggingActionsProvider.goToSource(f);
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    private Action createCOPY_TO_CLBD_ACTION(RequestProcessor requestProcessor) {
        Action a = Models.createAction((String)NbBundle.getBundle(DebuggingActionsProvider.class).getString("CTL_CallstackAction_Copy2CLBD_Label"), (Models.ActionPerformer)new LazyActionPerformer(requestProcessor){

            @Override
            public boolean isEnabled(Object node) {
                if (node instanceof JPDADVThread) {
                    return !((JPDADVThread)node).getKey().isMethodInvoking();
                }
                if (node instanceof CallStackFrame) {
                    return !((JPDAThreadImpl)((CallStackFrame)node).getThread()).isMethodInvoking();
                }
                return true;
            }

            @Override
            public void run(Object[] nodes) {
                ArrayList<JPDAThread> threads = new ArrayList<JPDAThread>(nodes.length);
                for (Object node : nodes) {
                    JPDAThread t;
                    if (node instanceof JPDADVThread) {
                        threads.add((JPDAThread)((JPDADVThread)node).getKey());
                    }
                    if (!(node instanceof CallStackFrame) || threads.contains(t = ((CallStackFrame)node).getThread())) continue;
                    threads.add(t);
                }
                if (threads.isEmpty()) {
                    threads.add(DebuggingActionsProvider.this.debugger.getCurrentThread());
                }
                DebuggingActionsProvider.stackToCLBD(threads);
            }
        }, (int)Models.MULTISELECTION_TYPE_ANY);
        a.putValue("debuggerActionKind", "copyToClipboard");
        return a;
    }

    static final Action createGO_TO_SOURCE_ACTION(final RequestProcessor requestProcessor) {
        return Models.createAction((String)NbBundle.getBundle(DebuggingActionsProvider.class).getString("CTL_ThreadAction_GoToSource_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                if (!(node instanceof CallStackFrame)) {
                    return false;
                }
                if (((JPDAThreadImpl)((CallStackFrame)node).getThread()).isMethodInvoking()) {
                    return false;
                }
                return DebuggingActionsProvider.isGoToSourceSupported((CallStackFrame)node);
            }

            public void perform(final Object[] nodes) {
                requestProcessor.post(new Runnable(){

                    @Override
                    public void run() {
                        DebuggingActionsProvider.goToSource((CallStackFrame)nodes[0]);
                    }
                });
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    static final Action createBREAKPOINT(final RequestProcessor async) {
        return Models.createAction((String)Bundle.CTL_CallstackAction_Breakpoint_Label(), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                return node instanceof CallStackFrame;
            }

            public void perform(Object[] nodes) {
                if (nodes.length == 1 && nodes[0] instanceof CallStackFrame) {
                    CompletionStage prepareBreakpoint = CompletableFuture.completedFuture((CallStackFrame)nodes[0]).thenApplyAsync(csf -> {
                        MethodBreakpoint mb = MethodBreakpoint.create((String)csf.getClassName(), (String)csf.getMethodName());
                        mb.setMethodName(csf.getMethodName());
                        mb.setBreakpointType(3);
                        return mb;
                    }, (Executor)async);
                    CompletionStage prepareDialog = ((CompletableFuture)prepareBreakpoint).thenComposeAsync(mb -> {
                        MethodBreakpointPanel p = new MethodBreakpointPanel((MethodBreakpoint)mb);
                        NotifyDescriptor nd = new NotifyDescriptor((Object)p, Bundle.CTL_CallstackAction_Breakpoint_Title(), 2, 3, null, null);
                        return DialogDisplayer.getDefault().notifyFuture(nd);
                    }, arg_0 -> ((Mutex)Mutex.EVENT).writeAccess(arg_0));
                    ((CompletableFuture)prepareDialog).thenAcceptBoth(prepareBreakpoint, (nd, mb) -> {
                        MethodBreakpointPanel p = (MethodBreakpointPanel)nd.getMessage();
                        if (nd.getValue() == NotifyDescriptor.OK_OPTION) {
                            if (p.ok()) {
                                DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb);
                            }
                        } else {
                            p.cancel();
                        }
                    });
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    static final Action createPOP_TO_HERE_ACTION(final RequestProcessor requestProcessor) {
        return Models.createAction((String)NbBundle.getBundle(ThreadsActionsProvider.class).getString("CTL_CallstackAction_PopToHere_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                if (node instanceof CallStackFrame) {
                    return !((JPDAThreadImpl)((CallStackFrame)node).getThread()).isMethodInvoking();
                }
                return true;
            }

            public void perform(final Object[] nodes) {
                requestProcessor.post(new Runnable(){

                    @Override
                    public void run() {
                        DebuggingActionsProvider.popToHere((CallStackFrame)nodes[0]);
                    }
                });
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    private Action createSUSPEND_ACTION(RequestProcessor requestProcessor) {
        return Models.createAction((String)NbBundle.getBundle(DebuggingActionsProvider.class).getString("CTL_ThreadAction_Suspend_Label"), (Models.ActionPerformer)new LazyActionPerformer(requestProcessor){

            @Override
            public boolean isEnabled(Object node) {
                if (node instanceof JPDADVThread) {
                    return !((JPDADVThread)node).isSuspended();
                }
                return node instanceof JPDAThreadGroup;
            }

            @Override
            public void run(Object[] nodes) {
                int k = nodes.length;
                for (int i = 0; i < k; ++i) {
                    Object node;
                    Object object = node = nodes[i] instanceof MonitorModel.ThreadWithBordel ? ((MonitorModel.ThreadWithBordel)nodes[i]).getOriginalThread() : nodes[i];
                    if (node instanceof JPDAThread) {
                        ((JPDAThread)node).suspend();
                        continue;
                    }
                    if (node instanceof JPDADVThread) {
                        ((JPDADVThread)node).suspend();
                        continue;
                    }
                    if (node instanceof JPDAThreadGroup) {
                        ((JPDAThreadGroup)node).suspend();
                        continue;
                    }
                    if (!(node instanceof JPDADVThreadGroup)) continue;
                    ((JPDADVThreadGroup)node).getKey().suspend();
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_ALL);
    }

    private Action createRESUME_ACTION(RequestProcessor requestProcessor) {
        return Models.createAction((String)NbBundle.getBundle(DebuggingActionsProvider.class).getString("CTL_ThreadAction_Resume_Label"), (Models.ActionPerformer)new LazyActionPerformer(requestProcessor){

            @Override
            public boolean isEnabled(Object node) {
                if (node instanceof JPDADVThread) {
                    return ((JPDADVThread)node).isSuspended();
                }
                return node instanceof JPDADVThreadGroup;
            }

            @Override
            public void run(Object[] nodes) {
                int k = nodes.length;
                for (int i = 0; i < k; ++i) {
                    Object node;
                    Object object = node = nodes[i] instanceof MonitorModel.ThreadWithBordel ? ((MonitorModel.ThreadWithBordel)nodes[i]).getOriginalThread() : nodes[i];
                    if (node instanceof JPDAThread) {
                        ((JPDAThread)node).resume();
                        continue;
                    }
                    if (node instanceof JPDADVThread) {
                        ((JPDADVThread)node).resume();
                        continue;
                    }
                    if (node instanceof JPDAThreadGroup) {
                        ((JPDAThreadGroup)node).resume();
                        continue;
                    }
                    if (!(node instanceof JPDADVThreadGroup)) continue;
                    ((JPDADVThreadGroup)node).getKey().resume();
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_ALL);
    }

    private Action createINTERRUPT_ACTION(RequestProcessor requestProcessor) {
        return Models.createAction((String)NbBundle.getBundle(DebuggingActionsProvider.class).getString("CTL_ThreadAction_Interrupt_Label"), (Models.ActionPerformer)new LazyActionPerformer(requestProcessor){

            @Override
            public boolean isEnabled(Object node) {
                if (node instanceof MonitorModel.ThreadWithBordel) {
                    node = ((MonitorModel.ThreadWithBordel)node).getOriginalThread();
                }
                if (node instanceof JPDAThread) {
                    return !((JPDAThread)node).isSuspended();
                }
                if (node instanceof JPDADVThread) {
                    return !((JPDADVThread)node).isSuspended();
                }
                return false;
            }

            @Override
            public void run(Object[] nodes) {
                int k = nodes.length;
                for (int i = 0; i < k; ++i) {
                    Object node;
                    Object object = node = nodes[i] instanceof MonitorModel.ThreadWithBordel ? ((MonitorModel.ThreadWithBordel)nodes[i]).getOriginalThread() : nodes[i];
                    if (node instanceof JPDAThread) {
                        ((JPDAThread)node).interrupt();
                        continue;
                    }
                    if (!(node instanceof JPDADVThread)) continue;
                    ((JPDADVThread)node).getKey().interrupt();
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_ALL);
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        if (node == "Root") {
            Action[] sa = this.getSessionActions();
            Action[] fa = ((DebuggingView.DVSupport)this.session.lookupFirst(null, DebuggingView.DVSupport.class)).getFilterActions();
            Action[] a = new Action[sa.length + 1 + fa.length];
            System.arraycopy(sa, 0, a, 0, sa.length);
            a[sa.length] = null;
            System.arraycopy(fa, 0, a, sa.length + 1, fa.length);
            return a;
        }
        if (node instanceof JPDAThreadGroup) {
            return new Action[]{this.RESUME_ACTION, this.SUSPEND_ACTION};
        }
        if (node instanceof JPDADVThread) {
            JPDADVThread t = (JPDADVThread)node;
            boolean suspended = t.isSuspended();
            Action a = null;
            a = suspended ? this.RESUME_ACTION : this.SUSPEND_ACTION;
            return new Action[]{this.MAKE_CURRENT_ACTION, a, this.INTERRUPT_ACTION};
        }
        if (node instanceof CallStackFrame) {
            boolean popToHere = this.debugger.canPopFrames();
            if (popToHere) {
                return new Action[]{this.MAKE_CURRENT_ACTION, this.POP_TO_HERE_ACTION, this.ADD_BREAKPOINT_ACTION, this.GO_TO_SOURCE_ACTION, this.COPY_TO_CLBD_ACTION};
            }
            return new Action[]{this.MAKE_CURRENT_ACTION, this.ADD_BREAKPOINT_ACTION, this.GO_TO_SOURCE_ACTION, this.COPY_TO_CLBD_ACTION};
        }
        throw new UnknownTypeException(node);
    }

    private Action[] getSessionActions() {
        return new Action[]{this.LANGUAGE_SELECTION};
    }

    public void performDefaultAction(final Object node) throws UnknownTypeException {
        if (node == "Root") {
            return;
        }
        if (node instanceof JPDADVThread || node instanceof CallStackFrame) {
            this.requestProcessor.post(new Runnable(){

                @Override
                public void run() {
                    if (node instanceof JPDADVThread) {
                        ((JPDADVThread)node).makeCurrent();
                    } else if (node instanceof CallStackFrame) {
                        CallStackFrame f = (CallStackFrame)node;
                        JPDAThread thread = f.getThread();
                        if (DebuggingActionsProvider.this.debugger.getCurrentThread() != thread) {
                            thread.makeCurrent();
                        }
                        f.makeCurrent();
                        DebuggingActionsProvider.goToSource(f);
                    }
                }
            });
            return;
        }
        if (node instanceof JPDAThreadGroup) {
            return;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }

    private static void popToHere(CallStackFrame frame) {
        try {
            JPDAThread t = frame.getThread();
            CallStackFrame[] stack = t.getCallStack();
            int k = stack.length;
            if (k < 2) {
                return;
            }
            for (int i = 0; i < k; ++i) {
                if (!stack[i].equals(frame)) continue;
                if (i > 0) {
                    stack[i - 1].popFrame();
                }
                return;
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
    }

    static void appendStackInfo(StringBuffer frameStr, JPDAThread t) {
        CallStackFrame[] stack;
        try {
            stack = t.getCallStack();
        }
        catch (AbsentInformationException ex) {
            frameStr.append(NbBundle.getMessage(CallStackActionsProvider.class, (String)"MSG_NoSourceInfo"));
            stack = null;
        }
        if (stack != null) {
            int k = stack.length;
            for (int i = 0; i < k; ++i) {
                frameStr.append("\tat ");
                frameStr.append(stack[i].getClassName());
                frameStr.append(".");
                frameStr.append(stack[i].getMethodName());
                try {
                    String sourceName = stack[i].getSourceName(null);
                    frameStr.append("(");
                    frameStr.append(sourceName);
                    int line = stack[i].getLineNumber(null);
                    if (line > 0) {
                        frameStr.append(":");
                        frameStr.append(line);
                    }
                    frameStr.append(")");
                }
                catch (AbsentInformationException absentInformationException) {
                    // empty catch block
                }
                if (i == k - 1) continue;
                frameStr.append('\n');
            }
        }
    }

    static void stackToCLBD(List<JPDAThread> threads) {
        StringBuffer frameStr = new StringBuffer(512);
        for (JPDAThread t : threads) {
            if (frameStr.length() > 0) {
                frameStr.append('\n');
            }
            frameStr.append("\"");
            frameStr.append(t.getName());
            frameStr.append("\"\n");
            DebuggingActionsProvider.appendStackInfo(frameStr, t);
        }
        Clipboard systemClipboard = DebuggingActionsProvider.getClipboard();
        StringSelection transferableText = new StringSelection(frameStr.toString());
        systemClipboard.setContents(transferableText, null);
    }

    static Clipboard getClipboard() {
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return clipboard;
    }

    private static boolean isGoToSourceSupported(CallStackFrame f) {
        String url = DebuggingNodeModel.getCachedFrameURL(f);
        return url != null;
    }

    private static void goToSource(CallStackFrame frame) {
        Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
        if (session == null) {
            return;
        }
        String language = session.getCurrentLanguage();
        DebuggerEngine engine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (engine == null) {
            return;
        }
        SourcePath sp = (SourcePath)engine.lookupFirst(null, SourcePath.class);
        String urlLang = DebuggingNodeModel.getCachedFrameURLLanguage(frame);
        if (urlLang != null) {
            language = urlLang;
        }
        sp.showSource(frame, language);
    }

    private static void goToSource(JPDADVThread thread) {
        Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
        if (session == null) {
            return;
        }
        String language = session.getCurrentLanguage();
        DebuggerEngine engine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (engine == null) {
            return;
        }
        SourcePath sp = (SourcePath)engine.lookupFirst(null, SourcePath.class);
        sp.showSource((JPDAThread)thread.getKey(), language);
    }

    private static class LanguageSelection
    extends AbstractAction
    implements Presenter.Popup {
        private Session session;

        public LanguageSelection(Session session) {
            this.session = session;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public JMenuItem getPopupPresenter() {
            JMenu displayAsPopup = new JMenu();
            Mnemonics.setLocalizedText((AbstractButton)displayAsPopup, (String)NbBundle.getMessage(DebuggingActionsProvider.class, (String)"CTL_Session_Popup_Language"));
            String[] languages = this.session.getSupportedLanguages();
            String currentLanguage = this.session.getCurrentLanguage();
            for (int i = 0; i < languages.length; ++i) {
                final String language = languages[i];
                JRadioButtonMenuItem langItem = new JRadioButtonMenuItem(new AbstractAction(language){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        session.setCurrentLanguage(language);
                    }
                });
                if (currentLanguage.equals(language)) {
                    langItem.setSelected(true);
                }
                displayAsPopup.add(langItem);
            }
            return displayAsPopup;
        }
    }

    static abstract class LazyActionPerformer
    implements Models.ActionPerformer {
        private RequestProcessor rp;

        public LazyActionPerformer(RequestProcessor rp) {
            this.rp = rp;
        }

        public abstract boolean isEnabled(Object var1);

        public final void perform(final Object[] nodes) {
            this.rp.post(new Runnable(){

                @Override
                public void run() {
                    this.run(nodes);
                }
            });
        }

        public abstract void run(Object[] var1);
    }
}

