/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.FSInfo;
import com.sun.tools.javac.util.Context;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class CacheFSInfo
extends FSInfo {
    protected final ConcurrentHashMap<Path, Path> canonicalPathCache = new ConcurrentHashMap();
    protected final ConcurrentHashMap<Path, Optional<BasicFileAttributes>> attributeCache = new ConcurrentHashMap();
    protected final ConcurrentHashMap<Path, List<Path>> jarClassPathCache = new ConcurrentHashMap();

    public static void preRegister(Context context) {
        context.put(FSInfo.class, c -> {
            CacheFSInfo instance = new CacheFSInfo();
            c.put(FSInfo.class, instance);
            return instance;
        });
    }

    public void clearCache() {
        this.canonicalPathCache.clear();
        this.attributeCache.clear();
        this.jarClassPathCache.clear();
    }

    @Override
    public Path getCanonicalFile(Path file) {
        return this.canonicalPathCache.computeIfAbsent(file, x$0 -> super.getCanonicalFile((Path)x$0));
    }

    @Override
    public boolean exists(Path file) {
        return this.getAttributes(file).isPresent();
    }

    @Override
    public boolean isDirectory(Path file) {
        return this.getAttributes(file).map(BasicFileAttributes::isDirectory).orElse(false);
    }

    @Override
    public boolean isFile(Path file) {
        return this.getAttributes(file).map(BasicFileAttributes::isRegularFile).orElse(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Path> getJarClassPath(Path file) throws IOException {
        ConcurrentHashMap<Path, List<Path>> concurrentHashMap = this.jarClassPathCache;
        synchronized (concurrentHashMap) {
            List<Path> jarClassPath = this.jarClassPathCache.get(file);
            if (jarClassPath == null) {
                jarClassPath = super.getJarClassPath(file);
                this.jarClassPathCache.put(file, jarClassPath);
            }
            return jarClassPath;
        }
    }

    protected Optional<BasicFileAttributes> getAttributes(Path file) {
        return this.attributeCache.computeIfAbsent(file, this::maybeReadAttributes);
    }

    protected Optional<BasicFileAttributes> maybeReadAttributes(Path file) {
        try {
            return Optional.of(Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }
}

