/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.xml.lexer;

import java.util.Collection;
import java.util.EnumSet;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.xml.lexer.DTDLexer;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

public enum DTDTokenId implements TokenId
{
    TARGET("dtd-target"),
    SYMBOL("dtd-symbol"),
    STRING("dtd-string"),
    REFERENCE("dtd-ref"),
    PLAIN("dtd-plain"),
    KEYWORD("dtd-keyword"),
    DECLARATION("dtd-declaration"),
    ERROR("dtd-error"),
    WS("dtd-ws"),
    NAME("dtd-name"),
    OPERATOR("dtd-operator"),
    PI_CONTENT("dtd-processing"),
    CHARACTER("dtd-character"),
    COMMENT("dtd-comment");

    private final String primaryCategory;
    private static final Language<DTDTokenId> language;

    private DTDTokenId(String primaryCategory) {
        this.primaryCategory = primaryCategory;
    }

    public String primaryCategory() {
        return this.primaryCategory;
    }

    public static Language<DTDTokenId> language() {
        return language;
    }

    static {
        language = new LanguageHierarchy<DTDTokenId>(){

            protected Collection<DTDTokenId> createTokenIds() {
                return EnumSet.allOf(DTDTokenId.class);
            }

            public Lexer<DTDTokenId> createLexer(LexerRestartInfo<DTDTokenId> info) {
                return new DTDLexer(info);
            }

            public LanguageEmbedding<?> embedding(Token<DTDTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
                return null;
            }

            public String mimeType() {
                return "application/xml-dtd";
            }
        }.language();
    }
}

